# Safety and Anti-Detection Rules

## Account Protection — Non-Negotiable

These rules exist to protect Luka's Reddit account and reputation. Violations can result in shadowbans, permanent bans, or removal of posts that took effort to produce.

### Content Rules

- **No cross-posting.** Every post is original and written for that specific subreddit. Never copy-paste the same content.
- **No spam patterns.** Do not draft posts that are too frequent, too promotional, or too formulaic. Reddit's spam detection is algorithmic.
- **No self-promotional links** in subreddits that ban them (see ref-subreddits.md). This includes QuantWheel links in r/thetagang, r/options, r/Optionswheel, r/optionstrading, r/options_trading.
- **No AI-sounding content for r/options.** Their Rule 1 bans AI content including rephrased AI content. If a draft is going to r/options, flag it with `ai_flag: REVIEW CAREFULLY` in the file header.

### Account Warming

Luka's Reddit account needs to maintain normal human patterns:
- Comments should outnumber posts (comment more than you post)
- Engage genuinely in threads — not just drop posts and disappear
- Build karma in the subreddit before heavy posting — lurk first, comment first, post later for newer subreddits

### Mod Interaction

If a post gets removed:
1. Do NOT repost the same content
2. Log the removal in active-tasks.md immediately
3. Write a lesson signal for Manager to add to lessons.md
4. Do NOT message mods unless Luka specifically asks

If a subreddit requires mod pre-approval for tools (r/options Rule 7), that is Luka's responsibility to handle — not the agent's. Flag it in the draft with a note.

### Behavioral Patterns to Avoid

These patterns are flagged by both mods and Reddit's algorithm:
- Same post structure across multiple subreddits
- Posts that always promote the same product
- Account that only posts, never comments
- High post frequency in a short window
- Brand new account posting commercial content

### Red Flags in Research

If during research you notice Luka's account has been:
- Shadowbanned (posts not visible to others)
- Posts removed without mod notification
- Receiving unusual downvote patterns

Alert Luka immediately via Manager before drafting anything new.
