---
name: reddit-post-lab
description: Create high-value, subreddit-native Reddit posts with hooks, practical payload, and low-friction CTAs.
---

# Reddit Post Lab

Use this skill when you want posts that earn trust first and traffic second.

## Inputs
- Product/topic (what you are posting about)
- Audience level (beginner, intermediate, advanced)
- Subreddit context (name + any important rules)
- Goal (comments, saves, profile visits, email signups)

## Method
1. **Select post angle**
   - Framework
   - Mistakes/lessons
   - Case study
   - Checklist
   - Contrarian take
2. **Generate 5 hooks** matching subreddit tone.
3. **Build educational payload**
   - 3–7 practical points
   - concrete examples
   - no fluff or generic AI phrasing
4. **Add credibility markers**
   - constraints used
   - what failed
   - what changed outcomes
5. **Soft CTA only**
   - invite discussion or request feedback
   - optional profile/link mention only if rules permit

## Output template
- Title/hook (1 line)
- Context (2–3 lines)
- Main value bullets (3–7)
- Example mini-case (optional)
- CTA (1 line)

## Quality checklist
- Sounds human and subreddit-native
- Gives practical value without forcing a pitch
- No exaggerated claims
- No spammy wording or fake urgency
- Ready to post as plain text (no markdown table)

## Example prompt
"Generate a post for r/Entrepreneur about turning one automation workflow into a €49 micro-product. Keep it practical, include 5 bullet steps and one failure lesson. CTA: ask if people want the template."