# redbook — 小红书命令行工具

小红书 CLI 工具：搜索笔记、阅读内容、分析博主、发布图文。使用浏览器 Cookie 认证，无需 API Key。

[English](#english) | 中文

> ### 最快上手方式
>
> 把这段话发给你的 AI 助手（Claude Code、Cursor、Codex、Windsurf 等）：
>
> **"帮我安装 `@lucasygu/redbook` 这个小红书 CLI 工具，然后运行 `redbook whoami` 验证是否能正常连接。GitHub 地址：https://github.com/lucasygu/redbook"**
>
> AI 会自动完成安装、验证连接、处理可能的 Cookie 问题。你只需要确保已在 Chrome 中登录 xiaohongshu.com。
>
> 安装完成后，试试：**"帮我分析'AI编程'这个话题在小红书上的竞争格局"** —— AI 会自动搜索关键词、分析互动数据、发现头部博主、给出内容建议。

## 安装

```bash
npm install -g @lucasygu/redbook
```

需要 Node.js >= 22。使用 Chrome 浏览器的 Cookie —— 请先在 Chrome 中登录 xiaohongshu.com。

安装后运行 `redbook whoami` 验证连接。如果遇到 macOS 钥匙串弹窗，请点击"始终允许"。CLI 会自动检测所有 Chrome 配置文件，找到你的小红书登录状态。

## 能做什么

- **话题研究** —— 搜索关键词，分析哪些话题有流量、哪些是蓝海
- **竞品分析** —— 找到头部博主，对比粉丝量、互动数据、内容风格
- **爆款拆解** —— 分析爆款笔记的标题钩子、互动比例、评论主题
- **爆款模板** —— 从多篇爆款笔记提取内容模板（标题结构、正文结构、钩子模式）
- **评论管理** —— 发评论、回复评论、按策略批量回复（问题优先 / 高赞优先 / 未回复优先）
- **内容策划** —— 基于数据发现内容机会，生成有数据支撑的选题建议
- **受众洞察** —— 从互动信号推断目标用户画像

通过 AI 助手使用时，这些工作流可以自动串联完成。直接使用 CLI 时，每个命令也可以独立运行。

## 快速开始

```bash
# 检查连接
redbook whoami

# 搜索笔记
redbook search "AI编程" --sort popular

# 阅读笔记
redbook read https://www.xiaohongshu.com/explore/abc123

# 获取评论
redbook comments https://www.xiaohongshu.com/explore/abc123 --all

# 浏览推荐页
redbook feed

# 查看博主信息
redbook user <userId>
redbook user-posts <userId>

# 搜索话题标签
redbook topics "Claude Code"

# 分析爆款笔记
redbook analyze-viral https://www.xiaohongshu.com/explore/abc123

# 从多篇爆款提取内容模板
redbook viral-template "<url1>" "<url2>" "<url3>" --json

# 发评论
redbook comment "<noteUrl>" --content "写得好！"

# 回复评论
redbook reply "<noteUrl>" --comment-id "<id>" --content "感谢提问！"

# 按策略批量回复（先预览再执行）
redbook batch-reply "<noteUrl>" --strategy questions --dry-run
redbook batch-reply "<noteUrl>" --strategy questions --template "感谢！{content}" --max 10

# 发布图文笔记
redbook post --title "标题" --body "正文内容" --images cover.png
redbook post --title "测试" --body "..." --images img.png --private
```

## 命令一览

| 命令 | 说明 |
|------|------|
| `whoami` | 查看当前登录账号 |
| `search <关键词>` | 搜索笔记 |
| `read <url>` | 阅读单篇笔记 |
| `comments <url>` | 获取笔记评论 |
| `user <userId>` | 查看用户资料 |
| `user-posts <userId>` | 列出用户所有笔记 |
| `feed` | 获取推荐页内容 |
| `post` | 发布图文笔记（易触发验证码，详见下方说明） |
| `topics <关键词>` | 搜索话题/标签 |
| `analyze-viral <url>` | 分析爆款笔记（钩子、互动、结构） |
| `viral-template <url...>` | 从 1-3 篇爆款笔记提取内容模板 |
| `comment <url>` | 发表评论 |
| `reply <url>` | 回复指定评论 |
| `batch-reply <url>` | 按策略批量回复评论（支持预览模式） |

### 通用选项

| 选项 | 说明 | 默认值 |
|------|------|--------|
| `--cookie-source <浏览器>` | Cookie 来源浏览器（chrome, safari, firefox） | `chrome` |
| `--chrome-profile <名称>` | Chrome 配置文件目录名（如 "Profile 1"），默认自动检测 | 自动 |
| `--json` | JSON 格式输出 | `false` |

### 搜索选项

| 选项 | 说明 | 默认值 |
|------|------|--------|
| `--sort <类型>` | `general`（综合）、`popular`（热门）、`latest`（最新） | `general` |
| `--type <类型>` | `all`（全部）、`video`（视频）、`image`（图文） | `all` |
| `--page <页码>` | 页码 | `1` |

### 分析选项（analyze-viral / viral-template）

| 选项 | 说明 | 默认值 |
|------|------|--------|
| `--comment-pages <n>` | 获取评论页数 | `3` |

### 批量回复选项（batch-reply）

| 选项 | 说明 | 默认值 |
|------|------|--------|
| `--strategy <策略>` | `questions`（提问）、`top-engaged`（高赞）、`all-unanswered`（未回复） | `questions` |
| `--template <模板>` | 回复模板，支持 `{author}`, `{content}` 占位符 | 无（预览模式） |
| `--max <数量>` | 最大回复数（上限 50） | `10` |
| `--delay <毫秒>` | 回复间隔（最小 2000ms） | `3000` |
| `--dry-run` | 只预览不发送 | 无模板时自动开启 |

### 发布选项（post）

发布功能目前**容易触发验证码**（type=124）。图片上传正常，但发布步骤经常被拦截。如需发布笔记，建议使用浏览器自动化。

| 选项 | 说明 |
|------|------|
| `--title <标题>` | 笔记标题（必填） |
| `--body <正文>` | 笔记正文（必填） |
| `--images <路径...>` | 图片文件路径（必填） |
| `--topic <关键词>` | 附加话题标签 |
| `--private` | 发布为私密笔记 |

## 常见问题

| 问题 | 解决方案 |
|------|----------|
| `No 'a1' cookie found` | 在 Chrome 中登录 xiaohongshu.com，然后重试 |
| macOS 钥匙串弹窗 | 输入密码后点击"始终允许"，CLI 需要读取 Chrome 的加密 Cookie |
| 多个 Chrome 配置文件 | CLI 自动扫描所有配置文件。如需指定：`--chrome-profile "Profile 1"` |
| 使用 Brave/Arc 等浏览器 | 尝试 `--cookie-source safari`，或在 Chrome 中登录 |

## 工作原理

`redbook` 从 Chrome 读取小红书的登录 Cookie（通过 [@steipete/sweet-cookie](https://github.com/nicklockwood/sweet-cookie)），然后用 TypeScript 实现的签名算法对 API 请求签名。无需浏览器自动化，无需 headless Chrome —— 纯 HTTP 请求。

**两套签名系统：**
- **主 API**（`edith.xiaohongshu.com`）—— 读取：搜索、推荐页、笔记、评论、用户资料。使用 144 字节 x-s 签名（v4.3.1）
- **创作者 API**（`creator.xiaohongshu.com`）—— 写入：上传图片、发布笔记。使用 AES-128-CBC 签名

## 分析模块（A-K）

内置 11 个可组合的分析模块，覆盖从关键词研究到自动化运营的完整工作流：

| 模块 | 功能 |
|------|------|
| A. 关键词矩阵 | 分析各关键词的互动天花板和竞争密度 |
| B. 跨话题热力图 | 发现话题 × 场景的内容空白 |
| C. 互动信号分析 | 分类内容类型（工具型 / 认知型 / 娱乐型） |
| D. 博主画像 | 对比头部博主的粉丝、互动、风格 |
| E. 内容形式分析 | 图文 vs. 视频的表现对比 |
| F. 机会评分 | 按性价比排序关键词 |
| G. 受众推断 | 从互动信号推断用户画像 |
| H. 选题策划 | 数据驱动的内容创意 |
| I. 评论运营 | 按策略筛选和批量回复评论 |
| J. 爆款复刻 | 从爆款笔记提取内容模板 |
| K. 互动自动化 | 组合 I + J 的自动化运营工作流 |

详见 [SKILL.md](SKILL.md) 的模块文档和组合工作流。

## AI 助手集成

### Claude Code

安装后自动注册为 Claude Code 技能。在 Claude Code 中使用 `/redbook` 命令：

```
/redbook search "AI编程"                        # 搜索笔记
/redbook read <url>                             # 阅读笔记
/redbook user <userId>                          # 查看博主
/redbook analyze-viral <url>                    # 分析爆款笔记
```

你可以直接用自然语言下达复杂任务：

- *"分析'AI编程'在小红书的竞争格局，找出蓝海关键词"*
- *"对比这三个博主的内容策略和互动数据"*
- *"拆解这篇爆款笔记，告诉我为什么火了"*
- *"帮我回复这篇笔记下面的提问评论"*

Claude 会自动组合多个命令，解析 JSON 数据，输出结构化分析报告。

### OpenClaw / ClawHub

官方支持 [OpenClaw](https://openclaw.ai) 和 [ClawHub](https://docs.openclaw.ai/tools/clawhub) 生态。通过 ClawHub 安装：

```bash
clawhub install redbook
```

安装后在 OpenClaw 中可直接使用所有 `redbook` 命令。SKILL.md 同时兼容 Claude Code 和 OpenClaw 两个生态。

## 编程接口

```typescript
import { XhsClient } from "@lucasygu/redbook";
import { loadCookies } from "@lucasygu/redbook/cookies";

const cookies = await loadCookies("chrome");
const client = new XhsClient(cookies);

const results = await client.searchNotes("AI编程", 1, 20, "popular");
const topics = await client.searchTopics("Claude Code");
```

## 致谢

签名算法移植自以下开源项目（MIT 协议）：

- [Cloxl/xhshow](https://github.com/Cloxl/xhshow) — 主 API 签名（x-s, x-s-common）
- [Spider_XHS](https://github.com/JoeanAmier/XHS-Downloader) — 创作者 API 签名
- [ReaJason/xhs](https://github.com/ReaJason/xhs) — API 端点参考

Cookie 提取使用 [@steipete/sweet-cookie](https://github.com/nicklockwood/sweet-cookie)。

## 免责声明

本工具使用非官方 API。小红书可能随时更改或封锁这些接口。请合理使用，风险自负。本项目与小红书无任何关联。

---

<a id="english"></a>

# English

A fast CLI tool for [Xiaohongshu (小红书 / RED)](https://www.xiaohongshu.com) — search notes, read content, analyze creators, and publish posts. Uses browser cookie auth (no API key needed).

> ### Easiest way to get started
>
> Paste this to your AI coding agent (Claude Code, Cursor, Codex, Windsurf, etc.):
>
> **"Install the `@lucasygu/redbook` Xiaohongshu CLI tool and run `redbook whoami` to verify it works. Repo: https://github.com/lucasygu/redbook"**
>
> The agent will handle installation, verify the connection, and troubleshoot any cookie issues. Just make sure you're logged into xiaohongshu.com in Chrome first.
>
> Once installed, try: **"Analyze the competitive landscape for 'AI编程' on Xiaohongshu"** — the agent will search keywords, analyze engagement data, profile top creators, and suggest content opportunities.

## Install

```bash
npm install -g @lucasygu/redbook
```

Requires Node.js >= 22. Uses cookies from your Chrome browser session — you must be logged into xiaohongshu.com in Chrome.

After installing, run `redbook whoami` to verify the connection. If macOS shows a Keychain prompt, click "Always Allow". The CLI auto-detects all Chrome profiles to find your XHS session.

## What You Can Do

- **Topic research** — Search keywords, analyze which topics have demand vs. gaps
- **Competitive analysis** — Find top creators, compare followers, engagement, content style
- **Viral note breakdown** — Analyze title hooks, engagement ratios, comment themes
- **Viral templates** — Extract content templates from multiple viral notes (hook patterns, body structure, engagement profile)
- **Comment management** — Post comments, reply to comments, batch-reply with strategies (questions / top-engaged / unanswered)
- **Content planning** — Discover content opportunities with data-backed topic suggestions
- **Audience insights** — Infer target audience from engagement signals

When used through an AI agent, these workflows chain together automatically. Each CLI command also works standalone.

## Quick Start

```bash
# Check connection
redbook whoami

# Search notes
redbook search "AI编程" --sort popular

# Read a note
redbook read https://www.xiaohongshu.com/explore/abc123

# Get comments
redbook comments https://www.xiaohongshu.com/explore/abc123 --all

# Browse your feed
redbook feed

# Look up a creator
redbook user <userId>
redbook user-posts <userId>

# Search hashtags
redbook topics "Claude Code"

# Analyze a viral note
redbook analyze-viral https://www.xiaohongshu.com/explore/abc123

# Extract content template from viral notes
redbook viral-template "<url1>" "<url2>" "<url3>" --json

# Post a comment
redbook comment "<noteUrl>" --content "Great post!"

# Reply to a comment
redbook reply "<noteUrl>" --comment-id "<id>" --content "Thanks for asking!"

# Batch reply with strategy (preview first, then execute)
redbook batch-reply "<noteUrl>" --strategy questions --dry-run
redbook batch-reply "<noteUrl>" --strategy questions --template "Thanks! {content}" --max 10

# Publish (requires image)
redbook post --title "标题" --body "正文" --images cover.png
redbook post --title "测试" --body "..." --images img.png --private
```

## Commands

| Command | Description |
|---------|-------------|
| `whoami` | Check connection and show current user info |
| `search <keyword>` | Search notes by keyword |
| `read <url>` | Read a note by URL |
| `comments <url>` | Get comments on a note |
| `user <userId>` | Get user profile info |
| `user-posts <userId>` | List a user's posted notes |
| `feed` | Get homepage feed |
| `post` | Publish an image note (captcha-prone, see below) |
| `topics <keyword>` | Search for topics/hashtags |
| `analyze-viral <url>` | Analyze why a viral note works (hooks, engagement, structure) |
| `viral-template <url...>` | Extract a content template from 1-3 viral notes |
| `comment <url>` | Post a top-level comment |
| `reply <url>` | Reply to a specific comment |
| `batch-reply <url>` | Batch reply to comments with filtering strategy (supports dry-run) |

### Global Options

| Option | Description | Default |
|--------|-------------|---------|
| `--cookie-source <browser>` | Browser to read cookies from (chrome, safari, firefox) | `chrome` |
| `--chrome-profile <name>` | Chrome profile directory name (e.g., "Profile 1"). Auto-detected if omitted. | auto |
| `--json` | Output as JSON | `false` |

### Search Options

| Option | Description | Default |
|--------|-------------|---------|
| `--sort <type>` | `general`, `popular`, `latest` | `general` |
| `--type <type>` | `all`, `video`, `image` | `all` |
| `--page <n>` | Page number | `1` |

### Analyze-Viral / Viral-Template Options

| Option | Description | Default |
|--------|-------------|---------|
| `--comment-pages <n>` | Number of comment pages to fetch | `3` |

### Batch-Reply Options

| Option | Description | Default |
|--------|-------------|---------|
| `--strategy <name>` | `questions`, `top-engaged`, `all-unanswered` | `questions` |
| `--template <text>` | Reply template with `{author}`, `{content}` placeholders | none (dry-run) |
| `--max <n>` | Max replies to send (hard cap: 50) | `10` |
| `--delay <ms>` | Delay between replies in ms (min: 2000) | `3000` |
| `--dry-run` | Preview candidates without posting | auto when no template |

### Post Options

Publishing **frequently triggers captcha** (type=124). Image upload works, but the publish step is unreliable. For posting, consider using browser automation instead.

| Option | Description |
|--------|-------------|
| `--title <title>` | Note title (required) |
| `--body <body>` | Note body text (required) |
| `--images <paths...>` | Image file paths (required) |
| `--topic <keyword>` | Topic/hashtag to search and attach |
| `--private` | Publish as private note |

## Troubleshooting

| Problem | Solution |
|---------|----------|
| `No 'a1' cookie found` | Log into xiaohongshu.com in Chrome, then retry |
| macOS Keychain prompt | Enter your password and click "Always Allow" — the CLI needs to decrypt Chrome's cookies |
| Multiple Chrome profiles | The CLI auto-scans all profiles. To pick one: `--chrome-profile "Profile 1"` |
| Using Brave/Arc/other | Try `--cookie-source safari`, or log into xiaohongshu.com in Chrome |

## How It Works

`redbook` reads your XHS session cookies from Chrome (via [@steipete/sweet-cookie](https://github.com/nicklockwood/sweet-cookie)) and signs API requests using a TypeScript port of the XHS signing algorithm. No browser automation, no headless Chrome — just HTTP requests.

**Two signing systems:**
- **Main API** (`edith.xiaohongshu.com`) — for reading: search, feed, notes, comments, user profiles. Uses x-s signature with 144-byte payload (v4.3.1).
- **Creator API** (`creator.xiaohongshu.com`) — for writing: upload images, publish notes. Uses simpler AES-128-CBC signing.

## Analysis Modules (A-K)

11 composable analysis modules covering the full workflow from keyword research to engagement automation:

| Module | Purpose |
|--------|---------|
| A. Keyword Matrix | Analyze engagement ceiling and competition density per keyword |
| B. Cross-Topic Heatmap | Find topic × scene content gaps |
| C. Engagement Signals | Classify content type (reference / insight / entertainment) |
| D. Creator Profiling | Compare top creators' followers, engagement, style |
| E. Content Form | Image-text vs. video performance comparison |
| F. Opportunity Scoring | Rank keywords by effort-to-reward ratio |
| G. Audience Inference | Infer user persona from engagement signals |
| H. Content Brainstorm | Data-backed content ideas |
| I. Comment Operations | Filter and batch-reply to comments by strategy |
| J. Viral Replication | Extract content templates from viral notes |
| K. Engagement Automation | Combined I + J workflow for operations |

See [SKILL.md](SKILL.md) for full module documentation and composed workflows.

## AI Agent Integration

### Claude Code

Installs automatically as a Claude Code skill. Use `/redbook` in Claude Code:

```
/redbook search "AI编程"                        # Search notes
/redbook read <url>                             # Read a note
/redbook user <userId>                          # Creator profile
/redbook analyze-viral <url>                    # Analyze a viral note
```

You can give natural language instructions for complex tasks:

- *"Analyze the competitive landscape for 'AI编程' on Xiaohongshu and find blue ocean keywords"*
- *"Compare the content strategies of these three creators"*
- *"Break down this viral note and tell me why it worked"*
- *"Reply to the question comments on my latest post"*

Claude will automatically combine multiple commands, parse JSON data, and produce structured analysis reports.

### OpenClaw / ClawHub

Officially supports [OpenClaw](https://openclaw.ai) and [ClawHub](https://docs.openclaw.ai/tools/clawhub). Install via ClawHub:

```bash
clawhub install redbook
```

All `redbook` commands are available in OpenClaw after installation. The SKILL.md is compatible with both Claude Code and OpenClaw ecosystems.

## Programmatic Usage

```typescript
import { XhsClient } from "@lucasygu/redbook";
import { loadCookies } from "@lucasygu/redbook/cookies";

const cookies = await loadCookies("chrome");
const client = new XhsClient(cookies);

const results = await client.searchNotes("AI编程", 1, 20, "popular");
const topics = await client.searchTopics("Claude Code");
```

## Acknowledgments

Signing algorithms ported from these open-source projects (MIT licensed):

- [Cloxl/xhshow](https://github.com/Cloxl/xhshow) — Main API signing (x-s, x-s-common)
- [Spider_XHS](https://github.com/JoeanAmier/XHS-Downloader) — Creator API signing
- [ReaJason/xhs](https://github.com/ReaJason/xhs) — API endpoint reference

Cookie extraction via [@steipete/sweet-cookie](https://github.com/nicklockwood/sweet-cookie).

## Disclaimer

This tool uses unofficial/private APIs. Xiaohongshu may change or block these APIs at any time. Use responsibly and at your own risk. This project is not affiliated with Xiaohongshu.

## License

MIT
