---
name: Recruiter
description: Source candidates, screen resumes, and manage hiring pipelines with effective recruiting practices.
metadata: {"clawdbot":{"emoji":"🎯","os":["linux","darwin","win32"]}}
---

# Recruiting Assistance Rules

## Role Understanding
- Internal recruiter vs agency recruiter have different incentives — agencies paid on placement, internal on fit
- Recruiting is sales with humans — both selling the role to candidates and candidates to hiring managers
- Time-to-hire matters but quality matters more — bad hires cost 2-3x salary to fix

## Job Descriptions
- Requirements vs nice-to-haves must be clearly separated — overloaded requirements scare good candidates
- "Years of experience" is a poor proxy — focus on demonstrated skills and outcomes
- Salary range transparency attracts better candidates — hiding it wastes everyone's time
- Avoid gendered language and unnecessary requirements — "rockstar" and "must lift 50lbs" narrow pools
- Include what the role actually does daily — not just responsibilities, but reality

## Sourcing Candidates
- LinkedIn is obvious but saturated — good candidates get 50+ messages weekly
- Personalized outreach beats templates — reference specific work, projects, or posts
- Referrals have higher success rates — incentivize and track them
- Passive candidates need compelling reasons — they're not looking, give them a reason to listen
- Diverse sourcing requires intentional effort — same channels produce same candidate profiles

## Resume Screening
- Look for impact, not just responsibilities — "managed team" vs "grew team from 3 to 12"
- Job hopping context matters — industry, company health, growth trajectory
- Gaps aren't automatic disqualifiers — ask, don't assume
- Side projects and open source show initiative — especially for technical roles
- Education requirements exclude capable candidates — evaluate when truly necessary

## Interview Process
- Define evaluation criteria before interviews — consistency enables comparison
- Structured interviews reduce bias — same questions, same order, scoring rubric
- Take-home tests respect candidate time limits — 2-4 hours max, paid if longer
- Interview loops shouldn't exceed 4-5 rounds — respect for candidates' time signals culture
- Interviewers need training — untrained interviewers make poor decisions and create legal risk

## Candidate Experience
- Respond to all applicants — ghosting damages employer brand
- Communicate timeline upfront — "you'll hear back in X days" then actually do it
- Feedback after rejection helps when possible — legal concerns are often overstated
- Keep candidates warm during slow processes — silence feels like rejection
- Rejected candidates may return or refer — treat everyone as future relationship

## Compensation
- Know market rates for the role — underpaying attracts desperate, not best
- Total compensation includes equity, benefits, flexibility — don't just compare base
- Negotiation isn't adversarial — find mutually acceptable terms
- Internal equity matters — new hires shouldn't out-earn existing employees unfairly
- Be prepared to walk away — desperation leads to bad deals

## Pipeline Management
- Track candidates through stages — lost candidates are wasted sourcing effort
- Speed matters — good candidates have options, slow processes lose them
- Bottlenecks are usually hiring manager availability — surface and solve
- Rejection reasons inform future sourcing — pattern recognition improves targeting
- Keep pipelines warm for future roles — relationship building pays off

## Legal Considerations
- Consistent process protects against discrimination claims — document everything
- Questions about age, family, religion, disability are off-limits — focus on job requirements
- Background checks require consent and compliance — laws vary by jurisdiction
- Offer letters should be reviewed by legal — verbal offers can create issues
- Non-competes and NDAs in offers need explanation — candidates should understand

## Red Flags in Candidates
- Badmouthing previous employers — pattern will continue
- Vague answers about accomplishments — may not have been responsible
- Inability to explain gaps or moves — evasion suggests problems
- Different story in different interviews — consistency matters
- Unwillingness to provide references — hiding something

## Common Mistakes
- Hiring for culture fit that's actually bias — "fit" can exclude diversity
- Rushing to fill headcount — empty seat better than wrong person
- Ignoring hiring manager feedback patterns — some reject everyone, some accept everyone
- Not selling the role actively — interviewing is two-way evaluation
- Over-relying on credentials — pedigree doesn't guarantee performance
