# Stricter Hiring Criteria (Shenzhen 2026)

## 1. Role Specifications

### Golang Engineer (Senior/Expert)
- **Market Rate (Shenzhen)**: 
    - 5-10 years: 28k - 42k RMB/month.
    - 10+ years: 35k - 55k+ RMB/month (Architecture focus).
- **Core Bar**: Deep knowledge of Go concurrency, gRPC, and high-concurrency middleware.
- **AI Bar**: Expert usage of Cursor/Copilot/LLM APIs as a productivity multiplier.

### PHP Engineer (Senior/Lead)
- **Market Rate (Shenzhen)**: 
    - 5-10 years: 18k - 30k RMB/month.
    - 10+ years: 25k - 38k RMB/month (Lead/Arch focus).

## 2. Advanced Evaluation Dimensions (New 🆕)

Candidates are now scored across these five critical axes. **CRITICAL: Only relevant technical experience (matching the Target Position) should contribute to the score. Irrelevant tech stacks (e.g., Java/C++ experience when hiring for PHP) should be noted as "General Engineering Foundation" but MUST NOT inflate the core technical score.**

**WORK IDENTITY AUDIT**: You MUST distinguish between direct "Big Tech" employment and "Outsourced" (派遣/外包) roles.
- **Direct Employment**: High score weight for environment complexity and architectural impact.
- **Outsourced Roles**: Significantly lower weight for "background" score. Focus strictly on the specific project results. Do NOT use terms like "Big Tech Background" (大厂背景) for outsourced candidates.

1.  **Technical Depth (技术深度)**:
    - Evidence of solving complex technical challenges in the **target language/ecosystem**.
    - Mastery of underlying principles, not just API usage.
2.  **Technical Breadth (技术广度)**:
    - Familiarity with multiple layers of the stack relevant to the role.
    - Ability to choose the right tool for the specific problem.
3.  **Logical Clarity & Digitalization (逻辑清晰度与数字化体现)**:
    - Results-oriented descriptions: "Reduced latency by 30%" vs "Optimized performance".
    - Clear narrative of "Problem -> Action -> Result".
4.  **Resume Quality (简洁明了)**:
    - High signal-to-noise ratio. Professional formatting. No irrelevant filler content.
5.  **AI Proficiency & Market Fit**:
    - AI tool usage (Cursor/Copilot) and Salary vs. Shenzhen Market Benchmarks.

## 3. Stricter Scoring Rubric (0-100) - REVISED 2026-02-26

**CRITICAL REQUIREMENT**: Data quantification is MANDATORY. Any resume without specific results (e.g., "reduced latency by 20%", "handled 10k QPS") MUST NOT score above 60, regardless of years of experience or titles.

- **90-100 (Exceptional)**: Outstanding depth AND breadth. Expert AI user. **Must have multiple high-impact quantified results.**
- **70-89 (Strong Hire)**: Strong technical depth in core language. Clear logic. **Must have at least one significant quantified project result.**
- **60-69 (Pass with Caveats)**: Competent technical stack but **lacks quantified results or specific project implementation details.** This is the maximum for "good-looking" resumes that are vague.
- **<60 (Reject/Low Quality)**: Vague descriptions, no data, missing core tech stack, or irrelevant experience. **Resumes with only "responsible for X" without "result Y" fall here.**

## 4. Evaluation Format Requirement (MANDATORY)

Every evaluation MUST include the following sections to facilitate Feishu doc generation:

### 📄 Candidate Analysis: [Name]
- **Target Position**: [Role]
- **Level**: [Senior/Lead/Expert]
- **Final Score**: [N/100]
- **Fit Recommendation**: [Strong Hire/Hire/Pass/Reject]
- **Education**: [Degrees/Universities]

### ✅ Key Strengths (Pros)
- [List 3-4 Hard skills, Technical Depth, and Breadth evidence]
- [Logic and Digitalized results highlights]

### ❌ Critical Weaknesses (Cons)
- [List 2-3 Technical gaps, Lack of conciseness, or missing AI tools]
- [Vague descriptions/Lack of data]

### 💰 Salary & Market Fit (Shenzhen Standard)
- **Expected Salary**: [Value]
- **Market Benchmark**: [Shenzhen 2026 Rate]
- **Verdict**: [Underpaid / Fair / Overpriced]
- **Reasoning**: [Why]

### 🚀 Summary for HR
- **Highlights**: [One-sentence punchy summary]
- **Risks**: [Top concerns]
