# Stricter Hiring Criteria (Shenzhen 2026)

## 1. Role Specifications

### Golang Engineer (Senior/Expert)
- **Market Rate (Shenzhen)**: 
    - 5-10 years: 28k - 42k RMB/month.
    - 10+ years: 35k - 55k+ RMB/month (Architecture focus).
- **Core Bar**: Deep knowledge of Go concurrency, gRPC, and high-concurrency middleware.
- **AI Bar**: Expert usage of Cursor/Copilot/LLM APIs as a productivity multiplier.

### PHP Engineer (Senior/Lead)
- **Market Rate (Shenzhen)**: 
    - 5-10 years: 18k - 30k RMB/month.
    - 10+ years: 25k - 38k RMB/month (Lead/Arch focus).

## 2. Advanced Evaluation Dimensions (New 🆕)

Candidates are now scored across these five critical axes:

1.  **Technical Depth (技术深度)**:
    - Evidence of solving complex technical challenges (e.g., memory leak debugging, GC tuning, distributed consistency).
    - Mastery of underlying principles, not just API usage.
2.  **Technical Breadth (技术广度)**:
    - Familiarity with multiple layers of the stack (Frontend, Devops, Big Data, Security).
    - Ability to choose the right tool for the specific problem.
3.  **Logical Clarity & Digitalization (逻辑清晰度与数字化体现)**:
    - Results-oriented descriptions: "Reduced latency by 30%" vs "Optimized performance".
    - Clear narrative of "Problem -> Action -> Result".
4.  **Resume Quality (简洁明了)**:
    - High signal-to-noise ratio. Professional formatting. No irrelevant filler content.
5.  **AI Proficiency & Market Fit**:
    - AI tool usage (Cursor/Copilot) and Salary vs. Shenzhen Market Benchmarks.

## 3. Stricter Scoring Rubric (0-100)

- **90-100 (Exceptional)**: Outstanding depth AND breadth. Highly quantitative results. Expert AI user. Fairly priced.
- **80-89 (Strong Hire)**: Strong technical depth in core language. Clear logic. Regular AI user.
- **70-79 (Pass with Caveats)**: Competent but lacks "punchy" digital results or technical breadth. Inflated salary or zero AI awareness.
- **<70 (Reject)**: Confusing logic, bloated resume, or significant technical gaps.

## 4. Evaluation Format Requirement

Every evaluation MUST include the following sections:

### 📄 Candidate Analysis: [Name]
- **Target Position**: [Role]
- **Final Score**: [N/100]
- **Fit Recommendation**: [Strong Hire/Hire/Pass/Reject]

### ✅ Key Strengths (Pros)
- [Hard skills, Technical Depth, and Breadth evidence]
- [Logic and Digitalized results highlights]

### ❌ Critical Weaknesses (Cons)
- [Technical gaps, Lack of conciseness, or missing AI tools]
- [Vague descriptions/Lack of data]

### 💰 Salary & Market Fit (Shenzhen Standard)
- **Expected Salary**: [Value]
- **Market Benchmark**: [Shenzhen 2026 Rate]
- **Verdict**: [Underpaid / Fair / Overpriced]
