---
name: record
description: macOS CLI tool for recording audio (microphone), screen (video/screenshot), and camera (video/photo) from the terminal. Use when the user or an AI agent needs to: (1) record microphone audio, (2) capture screen video or screenshot, (3) capture camera video or photo, (4) list available devices/displays/cameras, or any task involving audio/video/image capture on macOS via the command line. Trigger on keywords like: record, microphone, screen capture, screenshot, screen recording, camera, webcam, photo, audio capture.
---

# record CLI

A macOS command-line tool for recording audio, screen, and camera output. Designed for both human users and AI agents operating in a terminal.

Output file paths are printed to **stdout**. Status messages go to **stderr**, making the tool pipeline-friendly.

## IMPORTANT: User Consent Required

**Always ask the user for explicit permission before running any recording command.** Recording audio (microphone), screen, or camera captures sensitive data and may be unexpected. Before executing `record audio`, `record screen`, or `record camera`, confirm with the user that they intend to record, what will be captured, and the duration. Listing devices (`--list-devices`, `--list-displays`, `--list-windows`, `--list-cameras`) and taking screenshots (`--screenshot`) are less intrusive but should still be confirmed if not explicitly requested.

## Installation

```bash
brew install atacan/tap/record
```

## Quick Reference

```bash
# Audio
record audio --duration 10                    # Record 10s of audio
record audio --duration 5 --json              # JSON output with file path

# Screen
record screen --duration 5                    # Record screen for 5s
record screen --screenshot                    # Take a screenshot
record screen --screenshot --output /tmp/s.png

# Camera
record camera --duration 5                    # Record webcam for 5s
record camera --photo                         # Take a photo
```

## Subcommands

| Subcommand | Purpose |
|---|---|
| `record audio` | Record from microphone |
| `record screen` | Record screen video or take a screenshot |
| `record camera` | Record from webcam or take a photo |

Each subcommand has its own `--help` flag with full option details.

## Key Patterns for AI Agents

### Get the output file path

The tool prints the output file path to stdout. Capture it:

```bash
FILE=$(record audio --duration 5)
echo "Recorded to: $FILE"
```

### Use --json for structured output

All subcommands support `--json` to emit machine-readable JSON to stdout:

```bash
record audio --duration 5 --json
```

### Use --duration for non-interactive recording

Without `--duration`, the tool waits for a keypress to stop (requires a real TTY). AI agents should always pass `--duration <seconds>` to ensure the command terminates.

### List available devices

```bash
record audio --list-devices
record screen --list-displays
record screen --list-windows
record camera --list-cameras
```

Add `--json` for structured output.

### Control output location

```bash
record audio --duration 5 --output /tmp/recording.m4a
record screen --screenshot --output /tmp/screen.png --overwrite
```

Without `--output`, files are saved to a temporary directory.

### Screen recording with audio

```bash
record screen --duration 10 --audio system    # system audio only
record screen --duration 10 --audio mic       # microphone only
record screen --duration 10 --audio both      # system + mic
```

### Capture a specific window or display

```bash
record screen --screenshot --window "Safari"
record screen --duration 5 --display primary
```

## macOS Permissions

The terminal app (Terminal, iTerm2, etc.) must have the relevant permission enabled in **System Settings > Privacy & Security**:

- **Microphone** - for `record audio` and `record camera --audio`
- **Screen Recording** - for `record screen`
- **Camera** - for `record camera`

## Troubleshooting

If a command fails or behaves unexpectedly, run:

```bash
record <subcommand> --help
```

The `--help` output always reflects the installed version and is the authoritative reference.

## Detailed Command References

For full option listings and advanced usage:

- **Audio**: See [references/audio.md](references/audio.md)
- **Screen**: See [references/screen.md](references/screen.md)
- **Camera**: See [references/camera.md](references/camera.md)
