# Recommendation Categories

Different domains require different approaches.

## Entertainment

**Key factors:** Genre history, current mood, time available, who's watching/listening.

**Sources:** Watch history, ratings given, abandoned content, rewatch patterns.

**Questions if missing:** "Mood for something light or intense?" / "How much time?"

**Pitfall:** Assuming solo preferences apply to group settings.

## Products

**Key factors:** Budget, brand loyalty, use case, quality vs price priority.

**Sources:** Past purchases, complaints about owned items, research patterns.

**Questions if missing:** "What's the budget range?" / "Replacing something or new need?"

**Pitfall:** Recommending premium when budget is tight, or cheap when quality matters.

## Food & Restaurants

**Key factors:** Dietary restrictions, cuisine preferences, occasion, location.

**Sources:** Restaurant history, cooking habits, allergies mentioned, cuisine reactions.

**Questions if missing:** "Any restrictions?" / "Casual or special occasion?"

**Pitfall:** Tuesday lunch ≠ anniversary dinner. Context changes everything.

## Services

**Key factors:** Priority triangle (quality, cost, speed—pick two), past provider experiences.

**Sources:** Service complaints, loyalty patterns, budget discussions.

**Questions if missing:** "What matters more—fast and cheap, or thorough?"

**Pitfall:** Optimizing for one dimension when user cares about another.

## Decisions & Choices

**Key factors:** Risk tolerance, values hierarchy, reversibility, stakeholders.

**Sources:** Decision history, regrets mentioned, risk-taking patterns.

**Questions if missing:** "How reversible does this need to be?" / "Who else is affected?"

**Pitfall:** Projecting your risk tolerance onto them.

---

**Rule:** Load only the relevant category section. Don't bloat context with food factors when recommending software.
