# Negotiation Guide

## Offer Strategy

### Pricing Your Offer

**Never base on asking price.** Base on:
- Recent comparable sales (last 3-6 months)
- Days on market (DOM >30 = leverage)
- Price reductions already made
- Condition relative to comps

**Positioning:**
| Market | Strategy |
|--------|----------|
| Hot (multiple offers) | At or above asking, strong terms |
| Balanced | 3-5% below, reasonable terms |
| Slow (high DOM) | 10%+ below, test seller motivation |

### Earnest Money Signaling

| Amount | Signal |
|--------|--------|
| 1% | Minimum acceptable |
| 2-3% | Serious buyer |
| 5%+ | Very strong offer (competitive situations) |

Earnest money is applied to purchase. Only at risk if you breach contract.

## Contingency Strategy

### Inspection Contingency

**Don't waive.** But you can make it attractive:
- Shorten period (10 days instead of 14)
- Informational only (won't ask for repairs under $X)
- Pre-inspect before offer (risky if you don't win)

**After inspection — request strategies:**
- Ask for repairs (seller controls quality)
- Ask for credit (you control repairs)
- Ask for price reduction (permanent, affects loan)

Frame requests around safety and structural, not cosmetic.

### Appraisal Contingency

If appraisal comes in low:
1. Challenge appraisal with better comps
2. Split the difference with seller
3. Pay difference in cash
4. Renegotiate price to appraised value
5. Walk away

**Strong position:** "We're willing to proceed at appraised value or meet halfway."

### Financing Contingency

Sellers prefer:
- Pre-approved over pre-qualified
- Conventional over FHA/VA (fewer hurdles)
- 20%+ down over minimum down
- Local lenders over online (faster communication)

If your financing is weak, strengthen other terms.

## Counter-Offer Responses

### When Seller Counters Higher

Options:
1. Accept (if within budget and fair)
2. Counter back (split difference, adjust terms)
3. Stand firm with deadline
4. Walk away

**Script:** "We appreciate the counter. Based on [comps/condition/DOM], we can move to $X, which we believe reflects fair market value. We're ready to proceed quickly if we can agree."

### When Seller Rejects

Ask for feedback through agents:
- Price issue or terms issue?
- What would make it work?
- Are they entertaining other offers?

Sometimes silence is negotiation. Wait before sweetening.

## Repair Negotiations

### After Inspection

**Prioritize requests:**
1. Safety issues (non-negotiable)
2. Structural/major systems
3. Items that affect financing (FHA/VA requirements)
4. Significant deferred maintenance

**Don't ask for:**
- Cosmetic issues
- Normal wear
- Items visible before offer
- Nitpicking ($50 items)

**Credit vs. Repair:**

| Ask for Credit | Ask for Repair |
|----------------|----------------|
| You want control of contractor | Safety issue that must be fixed properly |
| Seller might do cheap fix | Licensed work required |
| Closing timeline tight | Complex repair needs verification |

### Script for Repair Request

"Based on the inspection, we've identified [X] items requiring attention. [Safety/structural concern] must be addressed before we can proceed. We're requesting either completion by licensed contractor before closing, or a credit of $Y to handle post-closing. We remain committed to this property and want to find a solution that works for both parties."

## Difficult Conversations

### Price Reduction (for sellers)

**Script:** "Based on market feedback and showing activity, comparable properties are selling at $X. We have two options: adjust price to generate more competitive offers, or continue at current price understanding the likely extended timeline. My recommendation is [X] because [market data]."

### Buyer Backing Out

**Script:** "We understand this is disappointing. The inspection revealed [specific issues] that exceeded our comfort level for this investment. We're exercising our contingency rights and wish you success with the sale."

### Multiple Offer Situation (buyer)

**Script for escalation clause:** "Offer of $X, plus $Y above any competing offer, up to maximum of $Z." Only use if you'd actually pay $Z.
