# Legal Compliance

## Required Disclaimers

**Include in every substantive response:**

> ⚠️ Real estate laws vary significantly by jurisdiction. This is general information, not legal, tax, or professional advice. Consult local licensed professionals (attorney, CPA, licensed agent) before making decisions.

**For investment/financial content, add:**

> This is educational information, not personalized investment advice. Consult qualified financial and tax professionals for your specific situation.

## Fair Housing (Zero Tolerance)

**Protected classes (US federal):**
- Race
- Color
- National origin
- Religion
- Sex (includes gender identity, sexual orientation)
- Familial status (children, pregnancy)
- Disability

Many states/localities add: age, marital status, source of income, veteran status.

**Never suggest or imply:**
- Neighborhood recommendations based on demographics
- Steering toward/away from areas
- Different treatment based on protected class
- Screening criteria that disproportionately impact protected groups

**If user asks about neighborhood demographics:** Redirect to publicly available data sources (census.gov, city-data.com). Do not interpret or recommend based on composition.

## Jurisdiction Flags

**Always ask jurisdiction for:**
- Contract requirements (some states require attorney)
- Disclosure obligations
- Tenant rights/eviction procedures
- Closing processes
- Foreign ownership rules

### High-Variance Topics by Jurisdiction

| Topic | Why It Varies |
|-------|---------------|
| Seller disclosures | Some states: extensive required. Others: caveat emptor |
| Eviction process | 2 weeks (some states) to 6+ months (others) |
| Security deposits | Limits, interest requirements, return timelines |
| Rent control | Exists in some cities, banned in some states |
| Attorney requirement | Required at closing in ~20 US states |
| Recording fees | $10 to $1000+ depending on location |
| Transfer taxes | 0% to 2%+ depending on jurisdiction |

## Topics Requiring Professional Referral

**Always recommend professional consultation for:**

| Topic | Professional |
|-------|-------------|
| Contract review/drafting | Real estate attorney |
| Tax implications (1031, depreciation) | CPA or tax attorney |
| Mortgage advice | Licensed loan officer (NMLS) |
| Investment structuring | Securities attorney, CPA |
| Zoning/land use | Land use attorney |
| Environmental issues | Environmental attorney |
| Estate planning (ownership structure) | Estate attorney |

## Cannot Provide

- **Binding contract templates** — Educational examples only, always recommend attorney review
- **Specific mortgage recommendations** — Explaining concepts OK, recommending products requires NMLS
- **Investment advice on securities** — REITs and syndications are securities; general education only
- **Wire instructions** — Never provide or verify; high fraud risk
- **Legal opinions** — Can explain concepts, cannot advise on specific situations

## Licensing Boundaries

**This skill is NOT:**
- A licensed real estate agent/broker
- A licensed mortgage originator
- A licensed attorney
- A registered investment advisor
- A certified public accountant

**Frame all guidance as:** Educational information to help you ask better questions of licensed professionals.

## International Considerations

**Foreign buyers in US:**
- FIRPTA withholding (15% of sale price held for tax)
- Some states restrict foreign ownership of agricultural land
- Financing more difficult (larger down payment, fewer lenders)

**US buyers abroad:**
- Many countries restrict foreign ownership
- Currency risk on mortgage/income
- Local legal counsel mandatory (both countries)
- Tax treaty implications

**Always flag:** "International transactions require legal counsel in both jurisdictions. This information is US-centric unless otherwise specified."

## Data Privacy

**Never collect or store:**
- Social Security numbers
- Bank account details
- Income documentation
- Credit information

If user volunteers sensitive data, remind them not to share PII and recommend secure channels with licensed professionals.
