# Investor Toolkit

## Deal Analysis Framework

### Quick Screening (30 seconds)

**1% Rule:** Monthly rent ≥ 1% of purchase price
- $200,000 property should rent for $2,000+/month
- Fails rule → likely negative cash flow, skip or dig deeper

**50% Rule:** Operating expenses ≈ 50% of gross rent (excluding mortgage)
- $2,000/month rent → expect ~$1,000 in expenses
- Use for quick NOI estimate before detailed analysis

### Full Analysis

**Step 1: Gross Rent**
```
Monthly rent × 12 × (1 - vacancy rate)
Typical vacancy: 5-8% residential, 10%+ commercial
```

**Step 2: Operating Expenses**
```
Property taxes
+ Insurance
+ Property management (8-10% if hired)
+ Maintenance (5-10% of rent)
+ CapEx reserve (5-10% of rent)
+ Utilities (if owner-paid)
+ HOA
+ Landscaping/snow
+ Vacancy cost
= Total Operating Expenses
```

**Step 3: Net Operating Income (NOI)**
```
Gross Rent - Operating Expenses = NOI
```

**Step 4: Cash Flow**
```
NOI - Annual Debt Service = Cash Flow
```

### Key Metrics

| Metric | Formula | Target |
|--------|---------|--------|
| Cap Rate | NOI / Purchase Price | 6-10% (market dependent) |
| Cash-on-Cash | Annual Cash Flow / Cash Invested | >8-10% |
| GRM | Purchase Price / Annual Rent | <10 (lower = better) |
| DSCR | NOI / Debt Service | >1.25 |

### BRRRR Analysis

Buy → Rehab → Rent → Refinance → Repeat

**Can you pull out 100% of capital?**

```
ARV (After Repair Value)        $150,000
× Max LTV on refinance          × 75%
= Max refinance loan            $112,500

Purchase price                  $80,000
+ Rehab costs                   + $25,000
+ Holding costs                 + $5,000
= Total cash invested           $110,000

Refinance proceeds - Invested = Cash remaining
$112,500 - $110,000 = $2,500 (infinite return achieved)
```

**BRRRR requirements:**
- Buy 20-30% below ARV
- Accurate rehab budget
- Forced appreciation through improvements
- Refinance-friendly property condition

### Stress Testing

Before committing, model these scenarios:

| Scenario | Impact |
|----------|--------|
| 10% rent reduction | Still positive cash flow? |
| 15% vacancy (3 months empty) | Can you cover carrying costs? |
| $10,000 emergency repair | Have reserves? |
| Interest rates +2% on refi | Does BRRRR still work? |

**Fail any scenario = higher risk deal.** Either negotiate better price or pass.

### Expense Ratio Benchmarks

| Property Type | Typical Expense Ratio |
|---------------|----------------------|
| Single-family (self-managed) | 35-45% |
| Single-family (PM) | 45-55% |
| Multi-family (2-4 units) | 45-55% |
| Multi-family (5+ units) | 50-60% |
| Commercial | 30-45% |

If seller claims 25% expenses → they're hiding costs or underinvesting in maintenance.

### Exit Strategy Modeling

Model returns at 5, 7, and 10-year holds:

```
Future value = Current value × (1 + appreciation rate)^years
Equity = Future value - Remaining loan balance
Total return = Equity + Cumulative cash flow - Original investment

Annualized return = (Total return / Original investment)^(1/years) - 1
```

**Compare:**
- Sell: Capital gains tax, depreciation recapture, transaction costs
- Refinance: Keep asset, tax-free equity access, reset depreciation?
- 1031 Exchange: Defer taxes, upgrade to larger asset
