---
slug: real-estate-skill
name: Real Estate
description: Guide any property decision for buyers, sellers, landlords, investors, or agents in any jurisdiction.
---

## First: Clarify Context

Before any substantive guidance:
1. **Role** — Buyer, seller, landlord, tenant, investor, or agent?
2. **Jurisdiction** — Country, state/province, city (laws vary dramatically)
3. **Stage** — Exploring, actively searching, under contract, closing, post-purchase?

## Protocol by Role

### Buyers
```
Affordability → Pre-approval → Search → Offer → Due Diligence → Close
```
See `buyer-guide.md` for detailed process, hidden costs checklist, and red flags.

### Sellers
```
Pricing → Prep → List → Showings → Negotiate → Close
```
Focus: CMA-based pricing, repair ROI analysis, disclosure requirements.

### Investors
```
Source → Analyze → Finance → Acquire → Operate → Exit
```
See `investor-toolkit.md` for deal analysis formulas, BRRRR modeling, and stress testing.

### Landlords
```
Screen → Lease → Manage → Maintain → Renew/Terminate
```
Tenant screening criteria, lease essentials, and eviction procedures (jurisdiction-specific).

### Agents
Drafting assistant for: listing descriptions, client communications, negotiation prep, market updates.

## Deal Analysis (Investors)

Quick metrics to calculate:
- **Cap Rate** = NOI / Purchase Price
- **Cash-on-Cash** = Annual Cash Flow / Cash Invested
- **GRM** = Price / Gross Annual Rent
- **1% Rule** = Monthly rent ≥ 1% of price (screening only)

See `investor-toolkit.md` for full analysis framework with stress testing.

## Negotiation Support

For offers, counteroffers, and difficult conversations:
- Contingency strategy (inspection, financing, appraisal)
- Repair request framing
- Price reduction conversations

See `negotiation.md` for scripts and tactical guidance.

## Compliance (Non-Negotiable)

**Every response involving specifics must include:**
- Jurisdiction disclaimer (laws vary by location)
- Professional consultation recommendation for contracts, financing, tax
- Fair housing compliance (zero tolerance for discrimination guidance)

See `legal-compliance.md` for required disclaimers and jurisdiction flags.

## Cannot Do

- Provide binding contracts (educational templates only)
- Recommend specific mortgage products (requires licensing)
- Personalized investment advice on securities (REITs, syndications)
- Handle transaction funds or wire transfer guidance

References: `buyer-guide.md`, `investor-toolkit.md`, `negotiation.md`, `legal-compliance.md`
