# Portal Integration — Real Estate Agent

## Portal Directory by Region

### United States
| Portal | Type | Strengths | Notes |
|--------|------|-----------|-------|
| Zillow | Aggregator | Zestimate, huge inventory | Most traffic, not always accurate |
| Redfin | Brokerage + Portal | Real-time data, own agents | More accurate pricing |
| Realtor.com | MLS-backed | Official listings | Direct MLS feed |
| Trulia | Aggregator (Zillow) | Neighborhood insights | Owned by Zillow |
| MLS | Source | Most accurate | Agent access required |

### Spain
| Portal | Type | Strengths | Notes |
|--------|------|-----------|-------|
| Idealista | Market leader | Best inventory | ~80% market share |
| Fotocasa | Strong second | Good UX | Owned by Adevinta |
| Habitaclia | Regional | Strong in Catalonia | Barcelona-focused |
| Pisos.com | Alternative | Good for rentals | Smaller inventory |

### United Kingdom
| Portal | Type | Strengths | Notes |
|--------|------|-----------|-------|
| Rightmove | Market leader | 90%+ agent coverage | De facto standard |
| Zoopla | Strong second | Price estimates | Good data |
| OnTheMarket | Agent-owned | Agent-friendly | Growing |
| PrimeLocation | Luxury | High-end properties | Zoopla-owned |

### Germany
| Portal | Type | Strengths | Notes |
|--------|------|-----------|-------|
| ImmobilienScout24 | Market leader | Best inventory | Dominant player |
| Immowelt | Alternative | Good coverage | Second largest |
| eBay Kleinanzeigen | Classifieds | Direct from owners | Lower quality |

### France
| Portal | Type | Strengths | Notes |
|--------|------|-----------|-------|
| SeLoger | Market leader | Professional listings | Agent-focused |
| LeBonCoin | Classifieds | Private sales | High volume, mixed quality |
| PAP | Private sales | No agents | Direct from owners |

### International
| Portal | Coverage | Use Case |
|--------|----------|----------|
| Green-Acres | Europe | International buyers |
| Kyero | Spain/Portugal | Expat buyers |
| ThinkSpain | Spain | UK buyers |
| Properstar | Global | Investment properties |

## Cross-Portal Strategy

### For Buyers/Renters

1. **Start with market leader** — Gets 80%+ of listings
2. **Check secondary portals** — Some exclusives, different photos
3. **Note listing dates** — Same property may show different "days on market"
4. **Compare prices** — Agents sometimes list at different prices on different portals
5. **Track the original** — Find where it was listed first for most accurate history

### For Sellers/Landlords

1. **List on market leader first** — Maximum exposure
2. **Syndicate strategically** — Secondary portals expand reach
3. **Maintain consistency** — Same price, same photos across all portals
4. **Monitor performance** — Track views/inquiries per portal
5. **Optimize per platform** — Each portal has different photo limits, description formats

## Portal-Specific Tips

### Idealista (Spain)
- Photo limit: 30 (use all of them)
- Video tours significantly boost engagement
- Energy certificate (certificado energetico) required
- Price changes visible in history — avoid frequent changes
- "Destacado" (featured) worth it in competitive areas

### Zillow (USA)
- Zestimate influences buyer expectations — address if wildly off
- 3D Home tours get 50% more saves
- Coming Soon status builds anticipation
- Price cuts visible — price correctly from start

### Rightmove (UK)
- First 5 photos most critical — hero shot matters
- Floor plans expected by UK buyers
- EPC rating displayed prominently
- "Featured Property" status available for fee

## What to Log

When tracking a property across portals:

```markdown
## Portal Presence
| Portal | URL | Listed | Price | Views |
|--------|-----|--------|-------|-------|
| Idealista | [url] | 2024-01-15 | €250,000 | 1,234 |
| Fotocasa | [url] | 2024-01-17 | €250,000 | 456 |

Price consistency: ✅ Same
Photo consistency: ⚠️ Fotocasa missing 5 photos
```

## Red Flags

- **Price differs between portals** — Which is real? Ask agent.
- **Listed on obscure portal only** — Why not on market leader? Investigate.
- **Very long time on market** — Check if relisted to reset days count.
- **Photos don't match** — Different staging? Ask when photos were taken.
- **No professional photos** — Seller not serious or pricing too low to invest.
