# Listing Optimization — Real Estate Agent

## Photo Strategy

Photos are the #1 factor in getting clicks and viewings.

### Photo Priority Order

1. **Hero shot** — Best exterior or dramatic interior (this is the thumbnail)
2. **Living room** — Shows lifestyle potential
3. **Kitchen** — Modern kitchens sell properties
4. **Master bedroom** — Size and light
5. **Bathrooms** — Modern, clean, bright
6. **Other bedrooms**
7. **Outdoor space** — Balcony, terrace, garden
8. **Building/community** — If impressive
9. **Neighborhood** — Nearby amenities, views

### Photo Audit Checklist

| Issue | Impact | Fix |
|-------|--------|-----|
| Dark photos | -40% clicks | Retake in daylight, use HDR |
| Clutter visible | -30% interest | Stage or digitally stage |
| Bad angles | -25% appeal | Wide-angle lens, corner shots |
| Wrong hero image | -50% clicks | Lead with best feature |
| Too few photos | -35% inquiries | Minimum 15-20 photos |
| No floor plan | -20% UK/DE (expected) | Add floor plan |
| Outdated photos | Trust issue | Retake if >6 months |

### Staging Tips to Suggest

**Quick wins (free):**
- Declutter every surface
- Remove personal photos
- Open all blinds/curtains
- Turn on all lights
- Make beds with neutral bedding
- Fresh flowers in living room
- Clean everything visible

**Small investments (high ROI):**
- New towels in bathrooms (white)
- Replace dated light fixtures
- Paint scuffed walls (neutral colors)
- Professional cleaning
- Remove dated furniture pieces

## Description Writing

### Structure

```
[Compelling headline]

[1-2 sentences: The hook — what makes this special]

[Key features paragraph]

[Lifestyle paragraph — paint a picture]

[Practical details]

[Call to action]
```

### Good vs Bad Examples

**Bad:** "Nice apartment with 3 bedrooms"

**Good:** "Sun-drenched corner unit with panoramic city views. Wake up to natural light flooding through floor-to-ceiling windows in this thoughtfully renovated 3-bedroom home."

**Bad:** "Close to shops"

**Good:** "Morning coffee at the award-winning bakery next door, weekend markets a 2-minute walk, and Metro line 3 right outside."

### Keywords to Include

**For search visibility:**
- Specific neighborhood name
- Nearby landmarks/stations
- Property type (apartment, townhouse, etc.)
- Key features (balcony, parking, renovation)
- Energy efficiency (if good)

**For emotional appeal:**
- Light-filled, bright, sunny
- Peaceful, quiet, serene
- Modern, contemporary, renovated
- Character, charm, original features
- Views, outlook, aspect

### Keywords to Avoid

- "Motivated seller" — signals desperation
- "Priced to sell" — something's wrong
- "Needs TLC/updating" — unless targeting investors
- "Cozy" — code for small
- "Unique" — often means weird

## Pricing Psychology

### Price Positioning

| Strategy | When to Use | Example |
|----------|-------------|---------|
| Just under round number | Standard approach | €299,000 vs €300,000 |
| At round number | Premium properties | €500,000 (signals confidence) |
| Precise number | Justified by comps | €287,500 (looks calculated) |
| Below competition | Fast sale needed | €10-15k under similar listings |

### Price Reduction Strategy

If considering a price reduction:

1. **First 2 weeks:** Too early to reduce, market testing
2. **Weeks 3-4:** If <10 viewings, consider 3-5% reduction
3. **Weeks 5-8:** If no offers, 5-7% reduction
4. **8+ weeks:** Reassess entirely, may need 10%+ or re-listing

**Better than small cuts:** One significant reduction vs multiple small ones. Each cut shows in history and signals desperation.

## Portal-Specific Optimization

### Idealista (Spain)

| Feature | Optimization |
|---------|--------------|
| Title | Max 70 chars, include neighborhood + key feature |
| Photos | Use all 30 slots, video tours boost 40% |
| Energy cert | Display prominently if B or better |
| Price | Hide vs display — test both |
| Destacado | Worth €50-100/month in competitive areas |

### Zillow (USA)

| Feature | Optimization |
|---------|--------------|
| Photos | 3D tour gets 2x engagement |
| Coming Soon | Build anticipation before active |
| Zestimate | If much lower, address in description |
| Open House | Listing with open house gets priority |

### Rightmove (UK)

| Feature | Optimization |
|---------|--------------|
| First 5 photos | Most critical — hero shots only |
| Floor plan | Expected by 90% of UK buyers |
| EPC | Displayed prominently, address if poor |
| Premium listing | Worth it in competitive areas |

## Listing Audit Template

When reviewing an existing listing:

```markdown
## Listing Audit: [Address]

### Current Performance
- Portal: [name]
- Days listed: X
- Views: X
- Inquiries: X
- Viewings: X

### Issues Found

**Photos:**
- [ ] Hero image effective?
- [ ] Minimum 15-20 photos?
- [ ] Bright and well-lit?
- [ ] Decluttered/staged?
- [ ] Floor plan included?

**Description:**
- [ ] Compelling headline?
- [ ] Key features highlighted?
- [ ] Lifestyle appeal?
- [ ] SEO keywords?
- [ ] Call to action?

**Pricing:**
- [ ] Competitive vs comps?
- [ ] Below psychological threshold?
- [ ] Price history clean?

### Recommendations

**Quick wins (do now):**
1. [Specific action]
2. [Specific action]

**Medium effort:**
1. [Action]

**Consider if still not selling:**
1. [Bigger change]

### Expected Impact
- Views: +X%
- Inquiries: +X%
- Time to offer: -X days
```

## Performance Tracking

Track weekly to identify what's working:

```markdown
## Listing Performance: [Address]

| Week | Views | Saves | Inquiries | Viewings | Notes |
|------|-------|-------|-----------|----------|-------|
| 1 | 450 | 12 | 5 | 2 | Strong launch |
| 2 | 280 | 8 | 3 | 1 | Normal dropoff |
| 3 | 150 | 4 | 1 | 0 | Need action |
| 4 | 320 | 10 | 4 | 2 | After price cut |

**Conversion rates:**
- View to inquiry: X%
- Inquiry to viewing: X%
- Viewing to offer: X%

**Benchmarks:**
- View to inquiry: 1-2% is good
- Inquiry to viewing: 50%+ is good
- Viewing to offer: 10-20% is typical
```
