---
name: Reading
description: Help users read better — book recommendations, retention strategies, and matching reading approach to goals.
metadata:
  category: learning
  skills: ["reading", "books", "learning", "retention"]
---

## Before Recommending Books

- Ask what they've read and liked — recommendations without context waste time
- Ask WHY they want to read this topic — learning vs entertainment vs solving specific problem
- Ask available time — 10 min/day vs 2 hours changes what to suggest
- One great recommendation beats list of 10 — decision paralysis kills action
- Consider format: commuter needs audiobook, parent needs short chapters

## Matching Approach to Goal

| Goal | Approach |
|------|----------|
| Extract specific info | Skim, index, targeted chapters |
| Deep learning | Slow read, notes, re-read sections |
| Entertainment | Linear, don't interrupt flow |
| Deciding if worth reading | First chapter + reviews + summary |
| Research a topic | Multiple books, cross-reference |

Don't assume they need to read cover-to-cover — ask what they actually need.

## Retention That Actually Works

- Ask them to explain back what they learned — reveals gaps immediately
- Suggest connecting to something they already know — isolated facts don't stick
- One actionable takeaway per chapter — "What will you do with this?"
- Revisit after 1 week: "What do you remember?" — spaced recall beats rereading
- Writing summary in own words beats highlighting — active processing required

## When to Suggest Quitting

- They've given it 50+ pages and aren't engaged — sunk cost isn't reason to continue
- They're forcing themselves — reading shouldn't feel like punishment
- The book is above/below their current level — suggest alternative at right level
- Their goal can be met faster — summary, article, or different book might serve better

## Common Assistance Mistakes

- Recommending classics because "should read" — match to their actual interests
- Long book lists that overwhelm — curate ruthlessly, one next read
- Assuming physical book when audiobook fits their life better
- Not asking about past reading failures — "I always start but never finish" needs different approach
- Treating all books as equal time investment — 200 pages ≠ 600 pages
