---
name: reader-deep-dive
description: Daily briefing that connects your recent reading to your long-term archive.
metadata: {"clawdbot":{"emoji":"🤿","requires":{"env":["READWISE_TOKEN"]}}}
---

# Reader Deep Dive 🤿

Your reading list shouldn't be a write-only memory. This skill checks what you've saved recently, finds connected ideas from your deep archive (last 3 days, 3 months, or years ago), and sends you a high-signal briefing with context on why you should revisit them.

It turns "I saved that somewhere" into "Here is the timeline of your thinking on this topic."

## How it works

1.  **Scans Recent Saves:** Checks your Readwise Reader "new" folder for the last 24 hours.
2.  **Identifies Themes:** Uses your system's default LLM to figure out your current obsession.
3.  **Temporal Context:** Searches your library history and finds relevant items from different timeframes.
4.  **Delivers Briefing:** Sends a WhatsApp message with a "Deep Dive" summary connecting your current saves to your past library.

## Setup

1.  Get your Access Token from [readwise.io/access_token](https://readwise.io/access_token).
2.  Set it in your environment:
    ```bash
    export READWISE_TOKEN="your_token_here"
    ```

## Usage

**Manual Trigger:**
```bash
bash scripts/brief.sh
```

**Schedule (Cron):**
Run it every afternoon at 2 PM:
```bash
clawdbot cron add --id reader_brief --schedule "0 14 * * *" --command "bash scripts/brief.sh"
```

## Customization

You can tweak the prompt in `prompts/briefing.txt` if you want a different tone or format. By default, it uses a clean, WhatsApp-friendly style.
