# Reader Deep Dive 🤿

**Your reading list shouldn't be a write-only memory.**

Most of us save articles, read them (maybe), and then forget them. We have a library of thousands of ideas, but we treat every new day like we're starting from zero.

This agent changes that. It scans what you're reading *right now* and connects it to the deepest cuts from your past. It doesn't just list links; it builds a timeline of your thinking on a specific topic.

## What It Does

Every afternoon (or on-demand), it runs a comprehensive research pass:

1.  **Detects Your Current Focus:** It analyzes your last 24 hours of saves to identify the core theme—whether it's "AI Agents," "Vibe Coding," or "Metabolic Health."
2.  **Mines Your Archive:** It searches your entire history for that topic, pulling from thousands of documents saved over years.
3.  **Synthesizes Intelligence:** It selects at least **5 deep-dive connections** and organizes them **chronologically** (Oldest to Newest) to show you the history of your thinking.
4.  **Enriches Metadata:** Every reference includes the **Author Name** and **Media Type** (tweet, video, article, etc.) for high-signal context.

## The Output

You get a high-signal WhatsApp message formatted for mobile readability:

> *TOPIC: AI AGENTS* 🎯
>
> *CURRENT FOCUS*
> * *Why OpenClaw feels alive* (tweet) by *claire vo* (Saved: Today)
> _Argues that "aliveness" comes from reactive loops rather than raw intelligence._
>
> *DEEP DIVE CONNECTIONS*
> * _One Year Ago_: *AutoGPT: The Dream of Autonomy* (video) by *Prompt Engineering* (Saved: 2024-05-20)
> _The original vision for self-improving agents. Revisiting this highlights the progress from "prompt engineering" to the "agentic engineering" patterns in your current saves._
> https://read.readwise.io/read/xyz
>
> * _Last Month_: *The Rise of the Wrapper* (article) by *Nat Friedman* (Saved: 2025-11-12)
> _An analysis of LLM thin-clients. This provides the architectural context for the more complex stateful frameworks you are exploring today._
> https://read.readwise.io/read/abc
>
> [... at least 3 more items ...]

## Setup

1.  **Get a Token:** Grab your Readwise Access Token from [readwise.io/access_token](https://readwise.io/access_token).
2.  **Set Environment:**
    ```bash
    export READWISE_TOKEN="your_token_here"
    ```
3.  **Run:**
    ```bash
    bash scripts/brief.sh
    ```

## Requirements

- `curl`, `jq`
- `clawdbot` (for LLM inference and WhatsApp delivery)
- `gemini` CLI (for stateless completion)
