# Business Types: Color Palettes & Image Packs

## How to Use

1. Pick the business type closest to the client
2. Copy the `primary` + `accent` color scales into `tailwind.config.js`
3. Use the Unsplash URLs in the component files

---

## 🌿 Landscaping / Garden / Outdoor

**Primary:** Emerald green | **Accent:** Earth/amber

```js
primary: { 50:"#f0fdf4",100:"#dcfce7",200:"#bbf7d0",300:"#86efac",400:"#4ade80",500:"#22c55e",600:"#16a34a",700:"#15803d",800:"#166534",900:"#14532d" },
accent:  { 400:"#facc15",500:"#b45309",600:"#92400e",700:"#78350f" },
neutral: { 50:"#fafaf9",100:"#f5f5f4",200:"#e7e5e4",400:"#a8a29e",600:"#57534e",800:"#292524",900:"#1c1917" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=1920&q=80`
- Hero alt: `https://images.unsplash.com/photo-1416879595882-3373a0480b5b?w=1920&q=80`
- Lawn care: `https://images.unsplash.com/photo-1592417817098-8fd3d9eb14a5?w=600&q=80`
- Garden design: `https://images.unsplash.com/photo-1585320806297-9794b3e4aaae?w=600&q=80`
- Trees: `https://images.unsplash.com/photo-1528360983277-13d401cdc186?w=600&q=80`
- Hardscaping: `https://images.unsplash.com/photo-1598300042247-d088f8ab3a91?w=600&q=80`
- About: `https://images.unsplash.com/photo-1523348837708-15d4a09cfac2?w=1200&q=80`
- Portfolio 1-6: use photo IDs: 1591857177580, 1558905585, 1464822759023, 1500382017468, 1549813069, 1416879595882 (all `?w=800&q=80`)

---

## 🍕 Restaurant / Café / Food & Beverage

**Primary:** Warm amber/orange | **Accent:** Deep red

```js
primary: { 50:"#fff7ed",100:"#ffedd5",200:"#fed7aa",300:"#fdba74",400:"#fb923c",500:"#f97316",600:"#ea580c",700:"#c2410c",800:"#9a3412",900:"#7c2d12" },
accent:  { 400:"#f87171",500:"#ef4444",600:"#dc2626",700:"#b91c1c" },
neutral: { 50:"#fafaf9",100:"#f5f5f4",200:"#e7e5e4",400:"#a8a29e",600:"#57534e",800:"#292524",900:"#1c1917" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1414235077428-338989a2e8c0?w=1920&q=80`
- Food/dish: `https://images.unsplash.com/photo-1504674900247-0877df9cc836?w=800&q=80`
- Interior: `https://images.unsplash.com/photo-1555396273-367ea4eb4db5?w=800&q=80`
- Chef: `https://images.unsplash.com/photo-1577219491135-ce391730fb2c?w=800&q=80`
- Coffee: `https://images.unsplash.com/photo-1495474472287-4d71bcdd2085?w=600&q=80`
- Brunch: `https://images.unsplash.com/photo-1533089860892-a7c6f0a88666?w=600&q=80`
- Bar: `https://images.unsplash.com/photo-1572116469696-31de0f17cc34?w=600&q=80`

---

## 💈 Hair Salon / Beauty / Spa

**Primary:** Dusty rose / mauve | **Accent:** Gold

```js
primary: { 50:"#fdf4ff",100:"#fae8ff",200:"#f5d0fe",300:"#f0abfc",400:"#e879f9",500:"#d946ef",600:"#c026d3",700:"#a21caf",800:"#86198f",900:"#701a75" },
accent:  { 400:"#fbbf24",500:"#f59e0b",600:"#d97706",700:"#b45309" },
neutral: { 50:"#fdf2f8",100:"#fce7f3",200:"#fbcfe8",400:"#f472b6",600:"#9d174d",800:"#831843",900:"#500724" },
```

**Or use neutral blush for a softer look:**
```js
primary: { 50:"#fff1f2",100:"#ffe4e6",200:"#fecdd3",300:"#fda4af",400:"#fb7185",500:"#f43f5e",600:"#e11d48",700:"#be123c",800:"#9f1239",900:"#881337" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1560066984-138dadb4c035?w=1920&q=80`
- Styling: `https://images.unsplash.com/photo-1522337360788-8b13dee7a37e?w=800&q=80`
- Salon interior: `https://images.unsplash.com/photo-1521590832167-7bcbfaa6381f?w=800&q=80`
- Spa: `https://images.unsplash.com/photo-1540555700478-4be289fbecef?w=800&q=80`
- Nails: `https://images.unsplash.com/photo-1604654894610-df63bc536371?w=600&q=80`
- Products: `https://images.unsplash.com/photo-1596462502278-27bfdc403348?w=600&q=80`

---

## 🔧 Plumbing / HVAC / Home Services

**Primary:** Navy blue | **Accent:** Orange/amber

```js
primary: { 50:"#eff6ff",100:"#dbeafe",200:"#bfdbfe",300:"#93c5fd",400:"#60a5fa",500:"#3b82f6",600:"#2563eb",700:"#1d4ed8",800:"#1e40af",900:"#1e3a8a" },
accent:  { 400:"#fb923c",500:"#f97316",600:"#ea580c",700:"#c2410c" },
neutral: { 50:"#f8fafc",100:"#f1f5f9",200:"#e2e8f0",400:"#94a3b8",600:"#475569",800:"#1e293b",900:"#0f172a" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1621905251189-08b45d6a269e?w=1920&q=80`
- Plumber at work: `https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800&q=80`
- Tools: `https://images.unsplash.com/photo-1504307651254-35680f356dfd?w=600&q=80`
- HVAC: `https://images.unsplash.com/photo-1581092795360-fd1ca04f0952?w=600&q=80`
- Team truck: `https://images.unsplash.com/photo-1600880292089-90a7e086ee0c?w=800&q=80`

---

## 💪 Gym / Fitness / Personal Training

**Primary:** Vibrant red or electric blue | **Accent:** Yellow

```js
// Option A: Power Red
primary: { 50:"#fff1f2",100:"#ffe4e6",400:"#fb7185",500:"#f43f5e",600:"#e11d48",700:"#be123c",800:"#9f1239",900:"#881337" },
// Option B: Electric Blue
primary: { 50:"#ecfeff",100:"#cffafe",400:"#22d3ee",500:"#06b6d4",600:"#0891b2",700:"#0e7490",800:"#155e75",900:"#164e63" },
accent:  { 400:"#facc15",500:"#eab308",600:"#ca8a04" },
neutral: { 50:"#fafafa",100:"#f4f4f5",400:"#a1a1aa",800:"#27272a",900:"#18181b" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1534438327276-14e5300c3a48?w=1920&q=80`
- Gym floor: `https://images.unsplash.com/photo-1571902943202-507ec2618e8f?w=800&q=80`
- Training: `https://images.unsplash.com/photo-1605296867304-46d5465a13f1?w=800&q=80`
- Classes: `https://images.unsplash.com/photo-1518611012118-696072aa579a?w=600&q=80`
- Equipment: `https://images.unsplash.com/photo-1583454110551-21f2fa2afe61?w=600&q=80`

---

## 🏠 Real Estate / Property Management

**Primary:** Deep navy or forest green | **Accent:** Gold

```js
primary: { 50:"#f0fdf4",100:"#dcfce7",400:"#4ade80",500:"#22c55e",600:"#16a34a",700:"#15803d",800:"#166534",900:"#14532d" },
accent:  { 400:"#fbbf24",500:"#f59e0b",600:"#d97706",700:"#b45309" },
neutral: { 50:"#fafaf9",100:"#f5f5f4",200:"#e7e5e4",400:"#a8a29e",600:"#57534e",800:"#292524",900:"#1c1917" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1564013799919-ab600027ffc6?w=1920&q=80`
- House exterior: `https://images.unsplash.com/photo-1568605114967-8130f3a36994?w=800&q=80`
- Living room: `https://images.unsplash.com/photo-1586023492125-27b2c045efd7?w=800&q=80`
- Kitchen: `https://images.unsplash.com/photo-1556909114-f6e7ad7d3136?w=600&q=80`
- Neighborhood: `https://images.unsplash.com/photo-1553434212-33e0e86b2cfd?w=800&q=80`

---

## 🐾 Veterinary / Pet Services

**Primary:** Teal/cyan | **Accent:** Warm yellow

```js
primary: { 50:"#f0fdfa",100:"#ccfbf1",400:"#2dd4bf",500:"#14b8a6",600:"#0d9488",700:"#0f766e",800:"#115e59",900:"#134e4a" },
accent:  { 400:"#facc15",500:"#eab308",600:"#ca8a04" },
neutral: { 50:"#f8fafc",100:"#f1f5f9",400:"#94a3b8",600:"#475569",800:"#1e293b",900:"#0f172a" },
```

**Images:**
- Hero: `https://images.unsplash.com/photo-1548199973-03cce0bbc87b?w=1920&q=80`
- Vet with dog: `https://images.unsplash.com/photo-1583512603805-3cc6b41f3edb?w=800&q=80`
- Examination: `https://images.unsplash.com/photo-1516734212186-a967f81ad0d7?w=800&q=80`
- Cat: `https://images.unsplash.com/photo-1514888286974-6c03e2ca1dba?w=600&q=80`

---

## Generic Business (Fallback)

When the business type is unclear, use a clean blue/slate palette:

```js
primary: { 50:"#eff6ff",100:"#dbeafe",200:"#bfdbfe",300:"#93c5fd",400:"#60a5fa",500:"#3b82f6",600:"#2563eb",700:"#1d4ed8",800:"#1e40af",900:"#1e3a8a" },
accent:  { 400:"#34d399",500:"#10b981",600:"#059669",700:"#047857" },
neutral: { 50:"#f8fafc",100:"#f1f5f9",200:"#e2e8f0",400:"#94a3b8",600:"#475569",800:"#1e293b",900:"#0f172a" },
```

---

## Unsplash URL Format Reference

```
https://images.unsplash.com/photo-{ID}?w={width}&q={quality}

Hero:        ?w=1920&q=80
Sub-hero:    ?w=1440&q=80
Cards/grid:  ?w=800&q=80
Thumbnails:  ?w=600&q=80
```

Always add `className="w-full h-full object-cover"` and an `alt` attribute to every `<img>`.
