# 代码审查检查清单

使用此清单确保每次代码审查的一致性和质量。

## 🔒 安全性检查

- [ ] 没有硬编码的密钥、密码或凭证
- [ ] SQL查询使用参数化，防止注入
- [ ] 用户输入经过验证和清理
- [ ] API接口有适当的认证和授权
- [ ] 敏感数据已加密存储/传输

## ⚡ 性能优化

- [ ] 避免N+1查询问题
- [ ] 大数据集使用分页
- [ ] 合理使用缓存
- [ ] 数据库查询有索引支持
- [ ] 避免不必要的循环嵌套

## 📝 代码质量

- [ ] 变量和函数命名清晰易懂
- [ ] 函数单一职责，不过长（<50行）
- [ ] 删除了注释掉的代码
- [ ] 移除了未使用的变量和导入
- [ ] 代码符合项目编码规范

## 🧪 测试覆盖

- [ ] 新增功能有对应的单元测试
- [ ] 测试用例覆盖边界情况
- [ ] 测试命名清晰描述测试场景
- [ ] 关键路径有集成测试
- [ ] 测试通过率100%

## 📚 文档

- [ ] 复杂逻辑有注释说明
- [ ] API接口有文档注释
- [ ] 重大改动更新了相关文档
- [ ] README已更新（如涉及功能变更）

## 🎯 功能完整性

- [ ] 实现了需求的所有功能点
- [ ] 边界情况已处理
- [ ] 错误处理完善
- [ ] 用户体验友好（错误提示清晰）

## 🔄 兼容性

- [ ] 不破坏现有功能
- [ ] 数据库迁移脚本已准备
- [ ] 向后兼容性已考虑
- [ ] API变更有版本控制

---

*每次代码审查时按此清单逐项检查*
