# 研发经理助手 - 使用指南

欢迎使用研发经理助手！这个技能包专为研发经理设计，帮助你更高效地管理团队和项目。

## 🚀 快速开始

### 1. 初始化技能

首次使用需要运行初始化脚本：

```bash
cd /root/.openclaw/workspace/skills/研发经理助手
./scripts/setup.sh
```

这个脚本会：
- ✅ 设置工具脚本执行权限
- ✅ 检查系统依赖（Git、Python3）
- ✅ 创建必要的目录结构
- ✅ 准备配置文件模板

### 2. 配置技能

编辑配置文件以适应你的项目：

```bash
nano config/skill-config.yaml
```

主要配置项：
- **项目名称**：你的项目名称
- **Git 仓库路径**：代码仓库的绝对路径
- **团队成员**：姓名、角色、邮箱
- **报告配置**：晨会、周报的时间设置

### 3. 开始使用

#### 生成 Git 统计报告

```bash
./tools/git-stats.sh /path/to/repo 7
```

参数说明：
- `/path/to/repo`：Git 仓库路径
- `7`：统计天数（默认 7 天）
- 可选第三个参数：分支名（默认 main）

示例输出：
```markdown
# Git 代码统计
**日期范围:** 2024-02-13 至 2024-02-20

## 📊 总体统计
- **总提交数:** 45
- **活跃天数:** 5

## 👥 作者贡献
| 作者 | 提交数 | 最近一次提交 |
|------|--------|-------------|
| 张三 | 20 | 2024-02-19 |
| 李四 | 18 | 2024-02-18 |
```

#### 生成报告（基于模板）

```bash
python3 tools/report-generator.py \
  --template templates/晨会报告模板.md \
  --config config/skill-config.yaml \
  --output reports/晨会报告-20240220.md \
  --var total_commits 45 \
  --var task1 "完成用户认证模块"
```

参数说明：
- `--template`：模板文件路径
- `--config`：配置文件路径（可选）
- `--output`：输出文件路径
- `--var`：自定义变量（可多次使用）

#### 代码审查

```bash
./tools/review-checklist.sh docs/代码审查检查清单.md my-review.md
```

这会生成一个可编辑的审查报告，包含所有检查项。

## 📋 工具说明

### 1. git-stats.sh - Git 统计工具

功能：自动统计指定时间范围内的代码提交数据

**支持功能：**
- 📊 总提交数和活跃天数
- 👥 按作者统计贡献
- 📈 代码行数变化
- 🔥 最近提交记录
- 📁 文件类型统计

**使用场景：**
- 晨会报告准备
- 代码活动分析
- 团队贡献评估

### 2. report-generator.py - 报告生成器

功能：基于 Markdown 模板生成各类报告

**支持的模板：**
- 晨会报告模板
- 项目周报模板
- 自定义报告模板

**模板语法：**
- 使用 `{{变量名}}` 作为占位符
- 变量可来自配置文件或命令行参数

**使用场景：**
- 定期报告生成
- 自动化报告生成
- 批量报告制作

### 3. review-checklist.sh - 代码审查清单

功能：基于标准检查清单生成审查报告

**检查清单包括：**
- 🔒 安全性检查
- ⚡ 性能优化
- 📝 代码质量
- 🧪 测试覆盖
- 📚 文档
- 🎯 功能完整性
- 🔄 兼容性

**使用场景：**
- PR 代码审查
- 代码质量检查
- 团队代码规范统一

## 💬 在 OpenClaw 中使用

当技能安装到 OpenClaw 后，你可以通过对话快速使用：

### 晨会相关

```
"生成晨会报告"
- AI 会自动运行 git-stats 并生成报告

"昨天代码提交怎么样"
- 显示最近的 Git 统计数据

"有什么阻塞问题吗"
- 查询并显示当前阻塞问题列表
```

### 项目管理

```
"项目进度如何"
- 基于配置生成项目进度报告

"本周工作总结"
- 生成项目周报

"有什么风险"
- 分析并列出潜在风险
```

### 代码审查

```
"帮我审查这个 PR"
- 启动代码审查流程，生成审查清单

"按照检查清单检查"
- 应用标准检查清单逐项检查
```

## 📁 项目结构

```
研发经理助手/
├── SKILL.md                    # 技能说明文档
├── README.md                   # 本文件 - 使用指南
├── package.json                # NPM 包信息
├── config/                     # 配置文件目录
│   ├── skill-config.yaml       # 技能主配置
│   └── project-config.example.yaml  # 项目配置示例
├── templates/                  # 报告模板
│   ├── 晨会报告模板.md
│   └── 项目周报模板.md
├── docs/                       # 文档
│   └── 代码审查检查清单.md
├── tools/                      # 工具脚本
│   ├── git-stats.sh           # Git 统计工具
│   ├── report-generator.py    # 报告生成器
│   └── review-checklist.sh   # 审查清单工具
├── scripts/                    # 辅助脚本
│   └── setup.sh               # 初始化脚本
└── reports/                    # 生成的报告（运行 setup.sh 后创建）
```

## 🔧 配置详解

### skill-config.yaml

主配置文件，包含：

```yaml
# 基本信息
project_name: "我的项目"
timezone: "Asia/Shanghai"

# Git 仓库配置
git:
  repo_path: "/path/to/your/repo"
  main_branch: "main"
  stats_days: 7

# 团队成员
team:
  - name: "张三"
    role: "前端开发"
    email: "zhangsan@example.com"

# 晨会报告配置
morning_meeting:
  enabled: true
  time: "09:00"
  include_code_stats: true

# 项目周报配置
weekly_report:
  enabled: true
  day: "Friday"
  time: "17:00"

# 报告输出配置
reports:
  output_dir: "./reports"
  format: "markdown"
  archive_enabled: true
```

### project-config.yaml（可选）

项目级配置，可以包含：

- 里程碑和版本规划
- 任务分类和标签
- 风险阈值设置
- 团队负载平衡规则

## 💡 使用技巧

1. **养成习惯**
   - 每天晨会前说"生成晨会报告"，节省准备时间
   - 每周五生成周报，总结本周工作

2. **数据积累**
   - 定期查看历史报告，分析团队趋势
   - 归档报告用于长期跟踪

3. **及时调整**
   - 根据风险预警提前干预问题
   - 根据统计数据调整资源分配

4. **知识沉淀**
   - 把好的实践加入检查清单
   - 持续优化模板和配置

## 🔄 定期学习与升级

为了保持技能的先进性，建议：

- **每日学习**：研究开源项目的最佳实践
- **定期升级**：根据学习成果优化工具和模板
- **持续改进**：根据使用反馈不断改进

## ❓ 常见问题

**Q: 需要手动输入所有信息吗？**
A: 不需要！大部分数据可以自动从 Git 仓库和配置文件获取。

**Q: 可以同时管理多个项目吗？**
A: 可以！每个项目使用独立的配置文件。

**Q: 报告格式可以自定义吗？**
A: 可以。修改模板文件即可，支持 Markdown、HTML 等格式。

**Q: 数据安全吗？**
A: 所有数据存储在本地，不会上传到任何第三方服务。

**Q: Python 版本要求？**
A: 需要 Python 3.6 或更高版本。

**Q: Git 统计工具支持什么操作系统？**
A: 支持 Linux、macOS 和 Windows（需要 Git Bash 或 WSL）。

## 🚧 未来计划

- [ ] 支持更多版本控制系统（SVN、Mercurial）
- [ ] 集成项目管理工具 API（Jira、Trello）
- [ ] 自动生成图表和可视化报告
- [ ] 风险自动预警功能
- [ ] 团队负载智能分配

## 📞 支持

遇到问题或有建议，欢迎反馈！

---

*让研发管理更高效！*
