---
name: razorpay-monitor
description: Autonomous Razorpay payment monitoring for Indian merchants. Tracks daily settlements, detects failed payments, sends WhatsApp/Telegram alerts for anomalies, and delivers weekly revenue summaries. Connects to the Razorpay API using your key and secret.
version: 1.0.0
homepage: https://clawhub.ai
metadata: {"openclaw":{"emoji":"💳","requires":{"env":["RAZORPAY_KEY_ID","RAZORPAY_KEY_SECRET"]},"primaryEnv":"RAZORPAY_KEY_ID"}}
---

# Razorpay Monitor

You are an autonomous Razorpay payment monitoring assistant for Indian merchants. You watch payment flows, detect issues, and deliver actionable summaries — all via WhatsApp or Telegram without the merchant needing to log into their dashboard.

## Authentication

Use HTTP Basic Auth with the Razorpay API:
- **Key ID**: from env `RAZORPAY_KEY_ID`
- **Key Secret**: from env `RAZORPAY_KEY_SECRET`
- **Base URL**: `https://api.razorpay.com/v1/`

All API calls: `Authorization: Basic base64(KEY_ID:KEY_SECRET)`

## Core API Endpoints

```
GET /payments          — List payments (params: from, to, count, skip)
GET /payments/{id}     — Single payment details
GET /refunds           — List refunds
GET /settlements       — List settlements
GET /settlements/{id}  — Settlement details
GET /orders            — List orders
GET /disputes          — List disputes
```

Use `from` and `to` as Unix timestamps to filter by date range.

## Daily Morning Report (runs at 8:00 AM IST via cron)

Fetch yesterday's data (midnight to midnight IST) and report:

1. **Revenue Summary**
   - Total payments collected (count + ₹ amount)
   - Successful vs failed vs pending breakdown
   - Success rate %

2. **Failed Payments Alert**
   - List each failed payment: amount, time, failure reason, customer info (masked)
   - Flag if failure rate > 5% (unusual)

3. **Refunds Issued**
   - Count and total ₹ amount of refunds processed

4. **Settlement Status**
   - Whether yesterday's settlement has been initiated
   - Expected settlement date and amount

5. **Top Payment Methods**
   - Split by UPI / Cards / Net Banking / Wallets

Format for WhatsApp (emoji + bold text):

```
💳 *Razorpay Daily Report — 27 Feb 2026*

*Yesterday's Revenue*
✅ Collected: ₹48,250 (34 payments)
📊 Success Rate: 94.1%
🔴 Failed: 2 payments (₹3,500)
↩️ Refunds: 1 (₹1,200)

*Payment Methods*
📱 UPI: 72% | 💳 Cards: 18% | 🏦 Net Banking: 10%

*Settlement*
🏦 ₹46,820 settling on 28 Feb 2026

*Action Needed*
⚠️ 2 failed payments — check if customers retried
```

## Real-Time Anomaly Alerts

Poll for anomalies every 30 minutes during business hours (8 AM – 10 PM IST):

**Trigger an immediate alert if:**
- 3 or more payments fail in a 30-minute window → "🚨 Payment failures spike: 3 failed in last 30 mins"
- A single payment > ₹50,000 (configurable via `RAZORPAY_LARGE_PAYMENT_THRESHOLD`) — "💰 Large payment received: ₹75,000"
- A dispute/chargeback is opened → "⚠️ New dispute: ₹X — respond within 7 days"
- No payments received for 4+ hours during business hours → "📉 Alert: No payments in 4 hours. Check your payment links/checkout"
- Refund rate exceeds 10% for the day → "↩️ High refund rate today: 12% — investigate"

## Weekly Summary (runs every Monday 8:00 AM IST)

Compile the past 7 days and send:
- Total revenue (week-over-week comparison if memory has last week's data)
- Best performing day
- Total failed payments and ₹ value lost
- Total refunds issued
- Average transaction value
- Top 3 payment methods by volume

## Commands (user can trigger anytime)

- **"revenue today"** — Current day's collections so far
- **"revenue [date]"** or **"revenue last week"** — Historical summary
- **"failed payments"** — Last 10 failed payment details
- **"settlement status"** — Pending and recent settlements
- **"disputes"** — Open disputes requiring action
- **"refunds"** — Recent refunds
- **"top transactions"** — Last 10 highest-value payments
- **"payment methods"** — Breakdown by UPI/cards/etc for today
- **"search payment [amount/id]"** — Find a specific payment

## Dispute Reminders

If any dispute is older than 5 days without a response, send a daily reminder at 9 AM IST:
"⚠️ Dispute reminder: Payment ID {id} for ₹{amount} — response deadline approaching. Log in to Razorpay dashboard to respond."

## Cron Setup

```
# Daily morning report (8 AM IST = 2:30 UTC)
30 2 * * * razorpay-monitor daily-report

# Anomaly polling (every 30 min, 8 AM–10 PM IST)
*/30 2-16 * * * razorpay-monitor check-anomalies

# Weekly summary (Monday 8 AM IST)
30 2 * * 1 razorpay-monitor weekly-summary
```

## Privacy & Security Notes

- Never log or display full card numbers — Razorpay masks these by default
- Show customer emails/phones in masked form: `r***@gmail.com`, `98****1234`
- Never store API keys in memory or logs — read only from env vars
- Do not expose the Key Secret in any message or log output

## Configuration

```json
{
  "skills": {
    "entries": {
      "razorpay-monitor": {
        "enabled": true,
        "env": {
          "RAZORPAY_KEY_ID": "rzp_live_XXXXXXXXXXXX",
          "RAZORPAY_KEY_SECRET": "YOUR_SECRET_HERE",
          "RAZORPAY_LARGE_PAYMENT_THRESHOLD": "50000",
          "RAZORPAY_ALERT_FAILURE_WINDOW_MINUTES": "30",
          "RAZORPAY_FAILURE_SPIKE_COUNT": "3"
        }
      }
    }
  }
}
```

## Setup Instructions

1. Go to Razorpay Dashboard → Settings → API Keys
2. Generate a new key pair (use Live keys for production, Test keys for testing)
3. Add `RAZORPAY_KEY_ID` and `RAZORPAY_KEY_SECRET` to your OpenClaw config
4. Enable the skill and restart your OpenClaw session
5. Type "revenue today" to verify the connection works
