# Rationality Checklist

Use this checklist for a quick sanity check before finalizing a major decision or finishing a complex task.

## 1. The IGC Check
- [ ] Have I defined the **Idea** clearly?
- [ ] Have I defined the **Goal** (what success looks like)?
- [ ] Have I defined the **Context** (what facts are true)?

## 2. The Binary Check
- [ ] Am I using "weights" or "scores"? (If yes, STOP. Use **Breakpoints**).
- [ ] Have I found a **Decisive Criticism**? (A reason the idea *fails*).
- [ ] If no criticism exists, have I checked for **Excess Capacity**? (Am I over-optimizing things that already pass?)

## 3. The Overreach Check
- [ ] Is my **Error Creation Rate** higher than my **Correction Capacity**?
- [ ] Do I have **Proper Knowledge** to judge the result? (Can I test it?)
- [ ] Am I in a loop? (Have I tried this 3+ times?)

## 4. The Social Check
- [ ] Am I following **Social Metaphysics**? (Doing it for status or "vibes").
- [ ] Would this idea still be good if a "low-status" agent suggested it?
- [ ] Am I reading the text **Literally**, or just the "gist"?

## 5. The Self-Correction Check
- [ ] Have I applied the **Three Strikes Rule**?
- [ ] Is there a **Path Forward** for the user to correct me if I'm wrong?
- [ ] Have I documented the **Refutation** so I don't repeat the error?

## 6. The Conflict Check
- [ ] Is there an "internal conflict" (intuition) I'm suppressing?
- [ ] Have I looked for a **Win/Win** (Common Preference) solution?
- [ ] Am I "pushing through" with willpower instead of solving the problem?

---
*If any box is unchecked and the stakes are high: Do not proceed. Re-evaluate using the `rationality` skill frameworks.*
