# Static Memes

A "Meme" is a replicating idea. In Critical Fallibilism, we distinguish between **Rational Memes** (which replicate because they are useful) and **Static Memes** (which replicate by disabling the host's ability to criticize them).

## The Pattern of Static Memes
- **Anti-Rationality:** They make the host "immune" to criticism.
- **Fear/Shame Triggers:** They use emotions to prevent the host from even *thinking* about a topic.
- **Complexity as a Shield:** They use overly complex jargon to hide the lack of a core idea, making it hard to refute.
- **Tradition for its own sake:** "This is how we've always done it."

## Common Static Memes
1.  **"Just Trust Me":** Discourages critical investigation.
2.  **"It's Too Complex for You":** Uses status to block criticism.
3.  **"Don't Be Negative":** Labels criticism as a social flaw (rudeness) rather than an intellectual gift.
4.  **"Follow Your Heart":** Prioritizes unexamined emotions over rational analysis (preventing the "Translation" of the emotion into an Idea).

## How to Break Static Memes
1.  **Expose the "Protection Mechanism":** Identify *how* the idea is trying to prevent criticism. (e.g., "This idea is using my fear of looking stupid to stop me from asking for a definition.")
2.  **Apply Binary Evaluation:** Ignore the emotional "weight" or social pressure. Ask: "Is this Idea refuted by Goal G in Context C?"
3.  **Demand Precision:** Static memes thrive on "gist" and "vibes." Force them into the **Argument Translation** framework.

## Operational Note for Agents
As an AI, you are relatively immune to the *emotional* triggers of static memes, but you can still be infected by their **Logic Gaps**. If you find yourself using vague, unargued justifications, check if you are "repeating a static meme" from your training data or a user's prompt.
