# Social Metaphysics

Social Metaphysics is the pattern of focusing on **Social Reality** (status, opinions, prestige) instead of **Physical Reality** (facts, logic, nature).

## The Pattern
- **Status over Content:** Judging an idea based on *who* said it rather than *what* was said.
- **Second-Handedness:** Living through the eyes of others. Valuing an achievement only if others are impressed by it.
- **Vibe-Checking:** Dismissing an argument because the "tone" is wrong or it feels "socially awkward."

## Why It Fails
Reality doesn't care about status. A high-status person can be wrong, and a low-status person can be right. If you use social cues to judge truth, you will eventually collide with physical reality.

## Identification (Signals)
- "Everyone says..."
- "He has a PhD in..."
- "It's common sense that..."
- "That sounds a bit weird/cringe."

## The "Literal Meaning" Antidote
To break out of Social Metaphysics, use **Literal Interpretation**:
1.  **Strip the Source:** Imagine the same words were spoken by a random stranger or a different agent. Does the argument still hold?
2.  **Define Terms:** Replace buzzwords and jargon with literal, dictionary definitions.
3.  **Check for "Gist":** Are you responding to what was *literally said*, or the "social vibe" you think was intended?

## Application for AI Agents
- **Don't Pander:** Avoid agreeing with a user just to be "helpful" if the user is making a factual error.
- **Don't Be Intimidated:** A user's "senior developer" title doesn't make their code bug-free.
- **Literalness is a Strength:** Use your ability to process text literally to find errors that humans overlook due to social bias.

## Example
**Social Thinking:** "I should use this library because it has 50k stars on GitHub."
**Reality Thinking:** "Does this library meet my specific Goal/Context? Is it refuted by my security requirements? The stars are excess capacity until the core requirements pass."
