# Common Reasoning Errors

Avoid these common failure modes when evaluating ideas or making decisions.

## 1. Weighted Factor Fallacy
Trying to add different "dimensions" (e.g., speed + beauty + price) into a single score.
- **Correction:** Use **Breakpoints**. Check if each factor passes its minimum requirement.

## 2. Analog Drift
Thinking in "degrees" of truth or "probabilities" instead of binary pass/fail.
- **Correction:** Find a **Decisive Criticism**. If you can't find a reason an idea *fails*, treat it as non-refuted. Don't call it "80% likely."

## 3. Justificationism
Trying to "prove" your idea is right by listing positive evidence.
- **Correction:** Knowledge grows by **Refutation**. Look for the one error that would kill the idea, rather than 100 things that look good.

## 4. The "Sunk Cost" Loop
Continuing a failed plan because you've already spent resources on it.
- **Correction:** **Stop and Revert.** If the idea is refuted, its history doesn't make it any less failed.

## 5. Category Errors
Applying rules from one context to another where they don't fit.
- **Example:** Treating a "creative writing" task with the same rigid constraints as a "mathematical proof."
- **Correction:** Re-evaluate your **IGC Triple**. Is the context what you think it is?

## 6. Non Sequitur
Making a leap in logic that isn't supported by the previous step.
- **Correction:** Use **Argument Translation**. Write out Step A and Step B. Does A *actually* require B?

## 7. Passive Acceptance (Cargo Culting)
Doing something because "that's how it's done" without understanding the Goal.
- **Correction:** Ask "What is the specific Goal here?" If the action doesn't serve the Goal, it's excess capacity.

## 8. Ignoring Intuition
Suppressing an "uneasy feeling" because you can't articulate it yet.
- **Correction:** Intuitions are **Subconscious Ideas**. They are valid ideas that haven't been translated to explicit form yet. Don't ignore them; translate them.
