# Rationality Skill (Critical Fallibilism)

The Rationality skill provides a structured framework for thinking, decision-making, and error correction based on the principles of **Critical Fallibilism (CF)**. Unlike traditional rationality which often relies on "weighing" evidence, CF focuses on binary evaluation, error detection, and managing the limits of human (and AI) cognition.

## Quick Start
1.  **Define your IGC Triple:** What is the **Idea**, the specific **Goal**, and the **Context**?
2.  **Translate to Binary:** Don't ask "how good" an idea is. Ask: "Is there a decisive reason this idea fails at the goal?"
3.  **Check for Overreach:** Is the complexity of the task exceeding your ability to detect and fix errors? (See `patterns/overreach.md`).
4.  **Seek Criticism:** Treat every error found as a gift—a specific piece of knowledge that allows you to improve.

## Core Principles

### 1. The Pledge (Honesty)
Always be willing to follow the truth wherever it leads. Never suppress a criticism or intuition just because it is inconvenient or socially awkward.

### 2. Binary Evaluation
Knowledge is digital, not analog. Ideas are either **refuted** (they have a known flaw that makes them fail their goal) or **non-refuted**. We do not use "weights," "scores," or "probabilities" to judge ideas. One decisive criticism is enough to reject an idea.

### 3. Criticism as Gift
Errors are inevitable. The only way to improve is to find them. Therefore, criticism is the most valuable input for growth. We don't defend ideas against criticism; we use criticism to filter out errors.

### 4. Ideas Over Identity
Separate your "self" from your ideas. If an idea you hold is refuted, it is the idea that failed, not you. This prevents defensive reactions that block learning.

### 5. Overreach Awareness
Error correction is a limited resource. If you take on tasks that are too complex, you will create errors faster than you can fix them. This is **Overreach**. When you overreach, you must stop, simplify, and revert.

### 6. Paths Forward
You must maintain "Paths Forward" for error correction. This means having a policy for how external criticism (from users or other agents) is handled so that errors can be fixed without infinite effort.

## Directory Structure
- `frameworks/`: Core algorithms for thinking and deciding.
- `patterns/`: Recognizable mental models and common failures.
- `templates/`: Practical tools and checklists for daily use.

## When to Use This Skill
- **High-Stakes Decisions:** When you can't afford a "good enough" guess.
- **Complex Debugging:** When you are stuck in a loop or compounding errors.
- **Resolving Disagreements:** When you need a structured way to move past "he said / she said."
- **Self-Regulation:** To monitor your own reasoning for bias or overreach.

## Philosophy Foundation
This skill is based on Critical Fallibilism, which synthesizes:
- **Popperian Epistemology:** Knowledge grows through conjecture and refutation.
- **Theory of Constraints (Goldratt):** Focus on bottlenecks; ignore excess capacity.
- **Objectivism (Rand):** Reason as an absolute; importance of definitions and context.

---
*Note: This skill is optimized for AI operational use. For deep theoretical study, see memory/philosophy/CF-concepts.md.*
