---
name: Raspberry Pi
description: Set up and maintain Raspberry Pi avoiding common hardware and configuration pitfalls.
metadata: {"clawdbot":{"emoji":"🍓","os":["linux","darwin"]}}
---

## Power Supply Issues
- Lightning bolt icon = undervoltage — random crashes, corruption, weird behavior until fixed
- Pi 4/5 needs 3A+ supply — older 2A adapters cause instability
- USB peripherals draw from Pi's power budget — use powered hub for multiple devices
- Official power supply recommended — cheap adapters often can't sustain required amperage

## Storage Reliability
- SD cards fail under heavy writes — databases and logs kill them within months
- USB boot with SSD for reliability — SD for bootloader only, root on SSD
- Quality SD cards matter — Samsung EVO, SanDisk Extreme; not generic cards
- Read-only filesystem for kiosks — prevents corruption on power loss

## GPIO Dangers
- 3.3V logic only — 5V input permanently damages the Pi, no protection
- Check operating voltage of sensors/modules — many Arduino accessories are 5V
- Some GPIO used by default — I2C, SPI, UART pins need dtparam to free up
- Hardware PWM only on GPIO 18 — software PWM on others is less precise

## Network Setup Traps
- WiFi country code required — won't connect without proper regulatory setting
- Headless SSH: empty file named `ssh` in boot partition — not `ssh.txt`
- Static IP via `/etc/dhcpcd.conf` — editing wrong file does nothing
- Don't port forward SSH — use Tailscale, Cloudflare Tunnel, or WireGuard

## Docker on Pi
- ARM images only — `linux/arm64` or `linux/arm/v7`, many images unavailable
- 32-bit OS limits to 3GB RAM — use 64-bit for 4GB+ models
- SD card unsuitable for Docker — volume writes accelerate card death
- Install via `curl -fsSL https://get.docker.com | sh` — apt version is outdated

## Headless Setup
- Configure hostname, WiFi, user in Raspberry Pi Imager — before first boot
- Username `pi` with default password deprecated — create custom user
- First boot takes 2-3 minutes — filesystem resize, don't panic

## Performance Tuning
- `gpu_mem=16` for headless — frees RAM when no display connected
- ZRAM for swap on low-RAM models — better than SD swap
- Disable Bluetooth and GUI if unused — saves resources

## Troubleshooting Patterns
- Red light only = power issue — no boot attempt, check supply
- Green light blinking patterns = specific boot failures — check documentation
- No HDMI output — connect before powering, Pi doesn't hot-plug HDMI
- Kernel panic on boot = corrupted SD — reflash image
- SSH refused — verify SSH enabled, check IP, check firewall
