---
name: ranked-gym
description: Gamify your gym sessions with XP, levels, achievements, and workout streaks
author: clawd-team
version: 1.0.0
triggers:
  - "gym rank"
  - "workout xp"
  - "gym level"
  - "fitness achievements"
  - "gym streak"
---

# Ranked Gym

Turn every rep into progress. Watch your fitness level up while you level up.

## What it does

Ranked Gym transforms your workout routine into an RPG progression system. Each session earns XP based on duration and intensity. Climb six ranks from Bronze through Master. Unlock achievements as you hit milestones. Track streaks to maintain momentum. See your stats on a persistent leaderboard. Stop counting reps—start counting levels.

## Usage

**Log workout for XP**
"Log 45 min upper body workout" → Earns 180 XP + intensity multiplier. Confirm reps or exercises for bonus points.

**Check rank**
"What's my gym rank?" → Returns current rank, XP progress to next level, total workouts completed, current streak.

**View achievements**
"Show my fitness achievements" → Lists unlocked badges with unlock dates. Shows progress on in-progress achievements.

**Streak status**
"Check my workout streak" → Days consecutive, best streak ever, streak multiplier (consecutive workouts = higher XP gains).

**Level up**
"Level up my gym profile" → Confirms rank advancement when you hit XP thresholds. Unlocks new rank badge and special ability.

## Rank System

Climb the ladder. Each rank requires progressively more XP.

- **Bronze** (0-500 XP) - You showed up. That's the win.
- **Silver** (500-1,500 XP) - Consistency matters. You're building the habit.
- **Gold** (1,500-3,500 XP) - Serious progress. People notice.
- **Platinum** (3,500-7,000 XP) - Elite tier. You're a machine.
- **Diamond** (7,000-12,000 XP) - Rare air. Few reach here.
- **Master** (12,000+ XP) - Legend status. The benchmark.

## Achievements

Unlock badges for hitting fitness milestones.

- **First Rep** - Complete your first logged workout. (Bronze unlock)
- **Week Warrior** - 7-day consecutive workout streak.
- **Century Club** - 100 total workouts logged.
- **Iron Grip** - 1,000 lbs total volume in a single session.
- **Unstoppable** - 30-day unbroken workout streak.
- **Marathon** - Single session exceeds 90 minutes.
- **Consistency King** - Workout every day for 60 days.
- **Volume Master** - Accumulate 50,000 lbs lifetime volume.
- **Perfect Month** - Complete planned workouts for entire month.
- **Legend Born** - Reach Master rank.

## Tips

1. **Streak is gold** - Consecutive days = XP multiplier. Break the chain and lose momentum fast. The streak is your most powerful motivator.

2. **Log everything** - Cardio, strength, sports, stretching—all count. The system rewards consistency over perfection. 10 min walk = XP earned.

3. **Mix intensity** - Quick sessions earn base XP. Heavy lifting or high-intensity days get multipliers. Variety keeps you climbing.

4. **Achievements compound** - Early badges feel trivial. But earning 10 of them? That's momentum. That's proof. Celebration is part of the game.

5. **All data stays local on your machine** - Your rank, streaks, achievements—zero cloud uploads. No tracking, no ads. Just you vs. your best self.
