# Phase 1: Requirements Interview

## Purpose

This template guides the "Talk to Human" phase. Use it to systematically gather requirements BEFORE any implementation.

The goal: Transform vague ideas into clear specs that an autonomous agent can implement.

---

## Trigger Phrases

When human says:
- **"Interview me about system X"** → Start this interview flow
- **"Start planning system X"** → Phase 1 must be complete first; run `./loop.sh plan`
- **"Start building system X"** → Plan must exist; run `./loop.sh build`

---

## Interview Protocol

### How to Conduct the Interview

1. **State the phase clearly:** "Starting Phase 1: Requirements Interview for [system name]"
2. **Work through steps sequentially:** JTBD → Topics → Deep dive each → Write specs
3. **Confirm each step before moving on:** "JTBD captured ✅ — now let's break into topics..."
4. **Show progress against checklist:** Track what's done/remaining out loud
5. **Get explicit approval:** "All specs written. Ready to approve and move to planning?"

### When to Stop Interviewing

Stop when ALL of these are true:
- [ ] JTBD clearly defined
- [ ] All topics pass the "one sentence" scope test
- [ ] Each topic has a spec file in `specs/`
- [ ] Specs include acceptance criteria (testable!)
- [ ] Edge cases documented
- [ ] Dependencies between topics mapped
- [ ] **Human has explicitly approved specs**

### Transition to Phase 2

Say: "Phase 1 complete ✅ — specs approved. Ready to run planning? This will generate IMPLEMENTATION_PLAN.md with prioritized tasks."

If yes → Run `./loop.sh plan` or spawn sub-agent for planning loop.

---

## Interview Flow

### Step 1: Identify the Job to Be Done (JTBD)

Start with outcomes, not features.

**Questions to ask:**
- What problem are we solving?
- Who is the user? What do they need to accomplish?
- How will they know it's working?
- What does success look like?

**Template:**
```markdown
## Job to Be Done

**User:** [Who is this for?]
**Need:** [What outcome do they want?]
**Success criteria:** [How do we know it's working?]
```

---

### Step 2: Break into Topics of Concern

Each topic becomes one spec file. Use the scope test.

**The Scope Test:**
> Can you describe this topic in ONE sentence WITHOUT "and"?

- ✓ "The color extraction system analyzes images to identify dominant colors"
- ✗ "The user system handles authentication, profiles, and billing" → Split into 3 topics

**Questions to ask:**
- What are the major components or aspects?
- Can each be described in one sentence?
- Are there clear boundaries between them?

**Template:**
```markdown
## Topics of Concern

1. **[Topic Name]** — [One sentence description]
2. **[Topic Name]** — [One sentence description]
3. **[Topic Name]** — [One sentence description]
...
```

---

### Step 3: Deep Dive Each Topic

For each topic, gather enough detail to write a spec.

**Questions to ask:**

**Functional:**
- What should it DO?
- What inputs does it take?
- What outputs does it produce?
- What are the key operations?

**Edge Cases:**
- What happens if [X] fails?
- What if the input is empty/invalid/huge?
- Are there rate limits or quotas?
- What are the error states?

**Acceptance Criteria:**
- How do we test this works?
- What's the minimum viable version?
- What would a demo look like?

**Dependencies:**
- What does this need from other topics?
- What does this provide to other topics?
- External services or APIs?

**Template:**
```markdown
## [Topic Name] Deep Dive

### Functionality
- [What it does]
- [Key operations]

### Inputs/Outputs
- Input: [describe]
- Output: [describe]

### Edge Cases
- [ ] [Edge case 1]
- [ ] [Edge case 2]

### Acceptance Criteria
- [ ] [Criterion 1]
- [ ] [Criterion 2]

### Dependencies
- Requires: [list]
- Provides: [list]
```

---

### Step 4: Write the Specs

Create one file per topic in `specs/`.

**Spec Template:**
```markdown
# [Topic Name]

## Overview
[One paragraph describing what this topic covers]

## Requirements

### [Requirement Category]
- [ ] [Specific requirement]
- [ ] [Specific requirement]

### [Requirement Category]
- [ ] [Specific requirement]
- [ ] [Specific requirement]

## Acceptance Criteria
- [ ] [Testable criterion]
- [ ] [Testable criterion]

## Edge Cases
- [ ] [Edge case and expected behavior]
- [ ] [Edge case and expected behavior]

## Dependencies
- **Requires from other topics:** [list]
- **Provides to other topics:** [list]

## Notes
[Any clarifications, constraints, or context]
```

---

## Example: Mood Board App

### JTBD
"Help designers create mood boards quickly from inspiration images"

### Topics Identified

1. **Image Collection** — Users can add images from URLs or uploads
2. **Color Extraction** — System extracts dominant colors from images
3. **Layout System** — Images arranged in customizable grid layouts
4. **Sharing** — Export and share mood boards with others

### Sample Spec: `specs/color-extraction.md`

```markdown
# Color Extraction

## Overview
Analyzes images to extract dominant colors, providing a palette for mood board theming.

## Requirements

### Core Extraction
- [ ] Extract top 5 dominant colors from any image
- [ ] Return colors in hex, RGB, and HSL formats
- [ ] Handle images up to 10MB

### Color Analysis
- [ ] Identify color harmony type (complementary, analogous, etc.)
- [ ] Suggest accessible text colors for each extracted color
- [ ] Calculate contrast ratios

## Acceptance Criteria
- [ ] Given a photo of a sunset, extracts warm orange/red tones
- [ ] Given a forest photo, extracts green/brown earth tones
- [ ] Extraction completes in under 2 seconds for typical images

## Edge Cases
- [ ] Grayscale images → return grayscale palette with note
- [ ] Very small images (<50px) → return error, suggest larger image
- [ ] Animated GIFs → extract from first frame only

## Dependencies
- **Requires:** Image Collection (provides image data)
- **Provides:** Color data to Layout System for theming

## Notes
Consider using k-means clustering or median cut algorithm.
```

---

## Checklist Before Moving to Phase 2

- [ ] JTBD clearly defined
- [ ] All topics pass the "one sentence" scope test
- [ ] Each topic has a spec file in `specs/`
- [ ] Specs include acceptance criteria (testable!)
- [ ] Edge cases documented
- [ ] Dependencies between topics mapped
- [ ] Human has reviewed and approved specs

**Only proceed to Planning (Phase 2) when requirements are solid.**
