# Ralph Loops — Setup Guide

Get your Clawdbot building autonomously in 5 minutes.

---

## Requirements

| Requirement | Check | Notes |
|-------------|-------|-------|
| **Node.js** v18+ | `node --version` | |
| **Claude Code** | `claude --version` | v2.1.25 recommended (2.1.29 has bugs) |
| **Clawdbot** | Running | With agent access |

### Install Claude Code

```bash
npm install -g @anthropic-ai/claude-code@2.1.25
claude --version  # Should show 2.1.25
```

---

## Installation

### 1. Install Dashboard Dependencies

```bash
cd skills/ralph-loops/dashboard
npm install
```

### 2. Start the Dashboard

```bash
node skills/ralph-loops/dashboard/server.mjs
```

Opens at: **http://localhost:3939**

### 3. Verify

- [ ] Dashboard loads in browser
- [ ] "Running Loops" section visible
- [ ] "Recent Archived" section visible

---

## Quick Test

Run a simple loop to verify everything works:

```bash
# Create test prompt
cat > /tmp/ralph-test.md << 'EOF'
# Test Loop
Each iteration: 
1. Read /tmp/test-count.txt (create with "0" if missing)
2. Increment the number
3. Write it back
4. Say "Count: X"

Do NOT output RALPH_DONE.
EOF

# Run 3 iterations
node skills/ralph-loops/scripts/ralph-loop.mjs \
  --prompt /tmp/ralph-test.md \
  --max 3 \
  --name "Test Loop"
```

**Watch the dashboard** — you'll see:
1. Loop appear in "Running Loops"
2. Iteration count climb
3. Loop move to "Recent Archived" when complete

---

## Troubleshooting

| Problem | Cause | Fix |
|---------|-------|-----|
| "exit code null" on iteration 1 | Claude Code 2.1.29 bug | `npm i -g @anthropic-ai/claude-code@2.1.25` |
| Dashboard won't start | Missing deps | `cd dashboard && npm install` |
| Dashboard shows stale data | Old process | `pkill -f "dashboard/server.mjs"` then restart |

---

## Next Steps

Setup complete! Read **SKILL.md** for:
- The 4 loop phases (Interview → Plan → Build → Generic)
- When to use Ralph (vs regular chat)
- Real project examples
- Cost expectations
