#!/usr/bin/env python3
"""Download a remote asset (e.g., TMDB poster) to a local file.

Usage:
  ./skills/radarr/scripts/fetch_asset.py --url <url> --out <path>

Prints JSON: {"ok": true, "path": "..."}
"""

from __future__ import annotations

import argparse
import json
import os
import pathlib
import urllib.request


def main(argv: list[str]) -> int:
    ap = argparse.ArgumentParser(prog="fetch_asset")
    ap.add_argument("--url", required=True)
    ap.add_argument("--out", required=True)
    args = ap.parse_args(argv)

    out_path = pathlib.Path(args.out)
    out_path.parent.mkdir(parents=True, exist_ok=True)

    req = urllib.request.Request(args.url, headers={"User-Agent": "openclaw-radarr-skill"})
    with urllib.request.urlopen(req, timeout=60) as resp:
        data = resp.read()

    out_path.write_bytes(data)

    print(json.dumps({"ok": True, "path": str(out_path)}, ensure_ascii=False))
    return 0


if __name__ == "__main__":
    raise SystemExit(main(os.sys.argv[1:]))
