# Radarr+ — Setup & configuration

This skill is designed to be easy to install and configure without committing any secrets.

## Install

### Option A — Install from ClawHub (recommended)

```bash
clawhub install radarr
```

### Option B — Install from a local folder

Copy the `radarr/` skill folder into your OpenClaw workspace skills directory.

## Configure (one-time)

Set env vars in `~/.openclaw/.env`:

Required:
- `RADARR_URL=http://<host>:7878`
- `RADARR_API_KEY=...`

Optional defaults (recommended):
- `RADARR_DEFAULT_PROFILE=HD-1080p`  (name or id)
- `RADARR_DEFAULT_ROOT=/data/media/movies` (path or id)

If defaults are not set, the assistant will prompt you to choose a profile/root at request time.

Optional add-ins (recommended):
- `TMDB_API_KEY=...` (poster + trailer)
- `OMDB_API_KEY=...` (IMDb rating)
- `PLEX_URL=http://<plex-host>:32400` (Plex link)
- `PLEX_TOKEN=...` (Plex link)

Reload OpenClaw if needed:

```bash
openclaw gateway restart
```

## Quick self-test

```bash
# ensure env vars are visible
./skills/radarr/scripts/check_env.py

# check Radarr connectivity
./skills/radarr/scripts/radarr.sh ping

# list profiles/root folders (use these values when adding)
./skills/radarr/scripts/radarr.sh profiles
./skills/radarr/scripts/radarr.sh roots
```

## Common pitfalls

- Wrong URL scheme (http vs https)
- API key pasted with whitespace
- Radarr is not reachable from the OpenClaw host (LAN routing/firewall)
