# Radarr API quick notes

This skill uses Radarr's v3 API.

Base URL:
- `${RADARR_URL}` (example: `http://10.3.3.46:7878`)

Auth:
- Header: `X-Api-Key: ${RADARR_API_KEY}`

Endpoints used by the scripts:
- `GET /api/v3/system/status` — health/status
- `GET /api/v3/qualityprofile` — list profiles
- `GET /api/v3/rootfolder` — list root folders
- `GET /api/v3/movie/lookup?term=<term>` — search/lookup
  - term can be `tmdb:<id>` or a free-text title
- `POST /api/v3/movie` — add movie
  - include `qualityProfileId`, `rootFolderPath`, `monitored`, `addOptions.searchForMovie`
- `POST /api/v3/command` — trigger actions
  - `{"name":"MoviesSearch","movieIds":[<id>]}`

Notes:
- Some Radarr versions behave differently with `addOptions.searchForMovie`. The script also triggers a `MoviesSearch` command after adding when `--search` is set.
