# Radarr+ — Onboarding

Radarr+ lets you request movies from chat and have them added to **Radarr**.

It’s built to work with **Radarr only** (minimum setup), and supports optional add‑ins for a richer experience:
- **TMDB** → poster + trailer
- **OMDb** → IMDb rating
- **Plex** → “open in Plex” link after download/import

---

## 0) What you need

### Minimum (required)
- A working Radarr instance reachable from your OpenClaw host
- Radarr API key

### Optional add‑ins (recommended)
- TMDB API key (poster + trailer)
- OMDb API key (IMDb rating)
- Plex URL + token (Plex link)

---

## 1) Install

### From ClawHub (recommended)

```bash
clawhub install radarr-plus
```

---

## 2) Configure secrets (one-time)

Put secrets in **`~/.openclaw/.env`** (never commit this file).

### Required

```bash
RADARR_URL=http://<radarr-host>:7878
RADARR_API_KEY=xxxxxxxx
```

### Optional add-ins (recommended)

```bash
TMDB_API_KEY=xxxxxxxx
OMDB_API_KEY=xxxxxxxx

PLEX_URL=http://<plex-host>:32400
PLEX_TOKEN=xxxxxxxx
```

### Optional defaults (skip prompts)
If you set these, requests can be 1‑turn because the bot won’t need to ask which profile/root folder to use.

```bash
RADARR_DEFAULT_PROFILE=HD-1080p    # or an id
RADARR_DEFAULT_ROOT=/movies        # or an id
```

Restart OpenClaw to ensure env changes are picked up:

```bash
openclaw gateway restart
```

---

## 3) Quick self-test

```bash
cd /home/vishix/.openclaw/workspace

# Validate env vars
./skills/radarr/scripts/check_env.py

# Verify Radarr connectivity
./skills/radarr/scripts/radarr.sh ping

# See what profiles and roots Radarr offers
./skills/radarr/scripts/radarr.sh profiles
./skills/radarr/scripts/radarr.sh roots
```

---

## 4) How to use (chat)

### Request a movie (DM or group)
Examples:
- `Request Interstellar`
- `Add Dune 2021`

What happens:
1) The bot looks up the movie.
2) If there are multiple matches, it asks you to confirm the right one.
3) If you didn’t set defaults, it asks which **quality profile** (and root folder if multiple).
4) It adds the movie to Radarr and starts search.
5) It posts progress updates and a final “imported ✅” message **in the same chat**.

### Poster + trailer
If `TMDB_API_KEY` is configured, the bot can send a **single message** containing:
- poster image (attachment)
- trailer link
- rating (TMDB; IMDb if OMDb is configured)

---

## 5) Notifications & progress tracking

Radarr+ uses a polling dispatcher (no Radarr webhooks required):
- It tracks state changes (pending → downloading → imported)
- It posts updates to the **same chat** where the request was made

If you want fewer/no progress messages, we can tune it later to only notify on “imported”.

---

## 6) Common issues

### “Unauthorized” / can’t connect to Radarr
- Check `RADARR_API_KEY` is correct
- Ensure Radarr is reachable from the OpenClaw host (`RADARR_URL`)

### Poster/trailer not showing
- Confirm `TMDB_API_KEY` is set:
  - `./skills/radarr/scripts/check_env.py`

### IMDb rating missing
- Add `OMDB_API_KEY`

### Plex link missing
- Add `PLEX_URL` and `PLEX_TOKEN`

---

## 7) Privacy & safety

- Secrets are read from `~/.openclaw/.env` only.
- The skill is add-focused; it does not delete media.
- Group usage should be restricted to trusted users via OpenClaw allowlists.
