---
name: radarr
description: Add and manage movies in a Radarr instance via its HTTP API (search/lookup movies, list quality profiles and root folders, add a movie by title/year or TMDB id, and trigger a search). Use when the user asks to add/request/download a movie via Radarr/Plex, or when automating Radarr-based media workflows.
---

# Radarr+

Request movies from chat and have them added to **Radarr** (with progress updates back in the same chat).

## What it looks like (example)

Here’s an example of the **single-message** poster card + caption users will receive when requesting a movie (poster attachment + trailer + rating):

![Example movie poster](https://image.tmdb.org/t/p/w185/nrmXQ0zcZUL8jFLrakWc90IR8z9.jpg)

Example message caption:

> **Shutter Island (2010)**
>
> ⭐ IMDb: 8.2/10
>
> 🎬 Trailer: https://www.youtube.com/watch?v=qdPw9x9h5CY
>
> Added to Radarr ✅ (Ultra-HD, /movies). I’ll post progress + “imported ✅” here.

## Setup (one-time)

1) Set secrets in `~/.openclaw/.env` (never commit these):

- `RADARR_URL=http://<host>:7878`
- `RADARR_API_KEY=...`

Optional (recommended for fewer questions later):
- `RADARR_DEFAULT_PROFILE=HD-1080p`
- `RADARR_DEFAULT_ROOT=/data/media/movies`

Optional (for the “rich” experience we’ll add next):
- `TMDB_API_KEY=...` (poster + trailer)
- `OMDB_API_KEY=...` (IMDb rating)
- `PLEX_URL=http://<plex-host>:32400`
- `PLEX_TOKEN=...`

2) Verify env + connectivity:

```bash
./skills/radarr/scripts/check_env.py
./skills/radarr/scripts/radarr.sh ping
```

If it fails, check:
- Radarr is reachable from the OpenClaw host
- API key is correct
- URL is correct (http vs https)

## Common tasks

### List available quality profiles

```bash
./skills/radarr/scripts/radarr.sh profiles
```

### List configured root folders

```bash
./skills/radarr/scripts/radarr.sh roots
```

### Lookup/search a movie

```bash
./skills/radarr/scripts/radarr.sh lookup --compact "inception"
./skills/radarr/scripts/radarr.sh lookup --compact "tmdb:603"
```

### Add a movie (preferred: TMDB id)

```bash
./skills/radarr/scripts/radarr.sh add --tmdb 603 --profile "HD-1080p" --root "/data/media/movies" --monitor --search
```

### Add a movie (by title; optionally prefer a year)

```bash
./skills/radarr/scripts/radarr.sh add --term "Dune" --year 2021 --profile "HD-1080p" --root "/data/media/movies" --monitor --search
```

## Chat workflow (recommended)

When the user says “request/add <movie>” (DM or group):

### 1) Lookup
Run:
- `./skills/radarr/scripts/radarr.sh lookup --compact "<movie>"`

If there are multiple plausible matches, ask the user to choose (year or TMDB id).

### 2) Resolve missing config by prompting
Resolve defaults from env (and fetch prompt options when missing):

```bash
./skills/radarr/scripts/resolve_defaults.py
```

If defaults are missing, prompt the user to pick one of the returned options:
- `options.profiles[]`
- `options.roots[]`

(If defaults exist, use them silently.)

### 3) Optional rich “movie card” (add-ins)
If `TMDB_API_KEY` is set, build a movie card:

```bash
./skills/radarr/scripts/movie_card.py --tmdb <id>
```

- If the output includes `posterUrl`, you can download it and attach it:

```bash
./skills/radarr/scripts/fetch_asset.py --url "<posterUrl>" --out "./outbound/radarr/<tmdbId>.jpg"
```

If `OMDB_API_KEY` is set and an IMDb id is known, the card will include IMDb rating.

### 4) Add to Radarr
Use TMDB when possible:

```bash
./skills/radarr/scripts/radarr.sh add --tmdb <id> --profile "<profile>" --root "<root>" --monitor --search
```

### 5) Track progress + notify in the same chat (Radarr-only, polling)
This skill provides a file-based tracker queue:

1) Enqueue tracking for the **same chat** where the request came from (DM or group):

```bash
./skills/radarr/scripts/enqueue_track.py --channel telegram --target "<chatId>" --movie-id <id> --title "<title>" --year <year>
```

2) A periodic dispatcher should run:

```bash
./skills/radarr/scripts/poll_and_queue.py
```

This will create outbox items under `./state/radarr/outbox/` that your OpenClaw cron runner can send.

### 6) Plex link (optional add-in)
If Plex is configured, try to produce a Plex web URL:

```bash
./skills/radarr/scripts/plex_link.py --title "<title>" --year <year>
```

## References

- Onboarding: `references/onboarding.md`
- Setup: `references/setup.md`
- API notes: `references/radarr-api-notes.md`
