# Qwen-TTS VoiceDesign Guide

## Voice Control

VoiceDesign permette di **descrivere la voce desiderata in linguaggio naturale**.

### Voice Presets

Wrapper `qwen-speak` con preset veloci:

```bash
scripts/qwen-speak "Text" [preset] [instruction]
```

**Preset disponibili:**

| Preset | Descrizione |
|--------|-------------|
| `female` | Voce femminile calda e gentile (default) |
| `male` | Voce maschile profonda e autorevole |
| `cheerful` | Voce femminile allegra ed energica |
| `narrator` | Narratore calmo e professionale |
| `child` | Voce bambino giocosa |
| `elderly` | Voce anziana saggia |

**Esempi:**
```bash
# Voce femminile
scripts/qwen-speak "Ciao Pasquale" female

# Voce maschile
scripts/qwen-speak "Attenzione, messaggio importante" male

# Narratore
scripts/qwen-speak "C'era una volta..." narrator

# Con emozione
scripts/qwen-speak "Sono felicissimo!" cheerful "with enthusiasm"

# Lento e chiaro
scripts/qwen-speak "Questo è importante" male "speak slowly and clearly"
```

### Custom Voice Descriptions

Per controllo totale, usa descrizioni personalizzate:

```bash
venv/bin/python3 scripts/tts-voicedesign.py \
  "Your text" \
  --remote http://192.168.188.177:8765 \
  -v "A deep, gravelly male voice with Italian accent" \
  -i "speak with sadness"
```

**Componenti descrizione voce:**

1. **Età:** young / middle-aged / elderly / child
2. **Genere:** male / female  
3. **Tono:** warm / deep / bright / soft / gravelly
4. **Carattere:** gentle / authoritative / cheerful / calm / playful
5. **Lingua/Accento:** Italian / with Italian accent
6. **Qualità:** clear pronunciation / smooth / raspy

**Esempi descrizioni:**

```
"A young energetic Italian female voice with bright tone"
"A middle-aged authoritative male voice with deep gravelly tone"  
"An elderly wise Italian male voice with calm pronunciation"
"A cheerful playful child voice"
"A warm soothing female voice for meditation"
"A professional Italian narrator with clear enunciation"
```

### Instructions (Stile/Emozione)

Istruzioni aggiuntive per controllare **come** parla:

**Emozioni:**
- `"with enthusiasm"` / `"with excitement"`
- `"with sadness"` / `"with melancholy"`
- `"angry tone"` / `"with anger"`
- `"with joy"` / `"happily"`
- `"with fear"` / `"nervously"`
- `"calmly"` / `"with serenity"`

**Ritmo:**
- `"speak slowly"` / `"speak slowly and clearly"`
- `"speak fast"` / `"speak quickly"`
- `"speak rhythmically"`
- `"with pauses"`

**Stile:**
- `"whisper softly"` / `"in a whisper"`
- `"shout loudly"` / `"yelling"`
- `"with emphasis on important words"`
- `"like reading a story"` / `"like a narrator"`
- `"in a dramatic way"`

**Combinazioni:**
```bash
scripts/qwen-speak "Attenzione!" male "speak slowly with emphasis"
scripts/qwen-speak "Ti amo" female "whisper softly with emotion"
scripts/qwen-speak "Corri!" child "shout loudly with excitement"
```

## Uso da OpenClaw

Quando chiedi audio a Loop, specifica stile e voce:

**Esempi richieste:**

> "Loop, audio con voce maschile profonda: Attenzione, zona riservata"

> "Loop, crea un messaggio vocale allegro: Buon compleanno!"

> "Loop, narratore calmo: C'era una volta in un piccolo paese..."

> "Loop, voce femminile sussurrata: Ti penso sempre"

> "Loop, voce bambino entusiasta: È il mio compleanno!"

Loop traduce automaticamente in parametri per VoiceDesign.

## Voice Cloning

⚠️ **Voice cloning richiede modello Base** (non VoiceDesign).

Se vuoi clonare la tua voce:

1. Cambia modello sul server Mac: `Qwen/Qwen3-TTS-12Hz-1.7B-Base`
2. Registra 3-10 secondi di audio pulito
3. Usa come riferimento:

```bash
venv/bin/python3 scripts/tts.py \
  "Text with cloned voice" \
  --remote http://192.168.188.177:8765 \
  --voice-sample /path/to/voice.wav
```

**Non disponibile con VoiceDesign attuale** - ma puoi descrivere una voce simile alla tua!

## Troubleshooting

**Audio monotono:**
- Aggiungi instruction: `"with emotion and varied tone"`
- Usa descrizione più espressiva: `"energetic"`, `"dramatic"`

**Voce non convincente:**
- Sii più specifico nella descrizione
- Combina più caratteristiche
- Esempio: invece di solo `"male"` → `"A middle-aged authoritative Italian male voice with clear pronunciation"`

**Troppo lento/veloce:**
- Aggiungi instruction: `"speak faster"` / `"speak slowly"`

**Server non risponde:**
- Verifica server attivo: `curl http://192.168.188.177:8765/`
- Controlla log server sul Mac
