# Qwen-TTS Server on Mac

Run Qwen-TTS as HTTP server on your Mac (192.168.188.177) for remote TTS.

## Setup on Mac

### 1. Install Dependencies

```bash
# Create Python virtual environment
python3 -m venv ~/qwen-tts-server
source ~/qwen-tts-server/bin/activate

# Install packages
pip install qwen-tts soundfile fastapi uvicorn
```

### 2. Copy Server Script

Transfer `scripts/server.py` to your Mac, or download from this machine:

```bash
# On Mac
scp brewuser@clawd:/path/to/qwen-tts/scripts/server.py ~/qwen-tts-server/
```

### 3. Start Server

```bash
# Activate venv
source ~/qwen-tts-server/bin/activate

# Run server (binds to all interfaces)
python3 ~/qwen-tts-server/server.py --host 0.0.0.0 --port 8765 --preload

# Or with custom model
python3 ~/qwen-tts-server/server.py --model Qwen/Qwen3-TTS-12Hz-1.7B-CustomVoice --preload
```

**Options:**
- `--host 0.0.0.0` - Listen on all interfaces
- `--port 8765` - Port number
- `--preload` - Load model on startup (recommended)
- `--model NAME` - Model to use (0.6B or 1.7B)

### 4. Verify Server Running

Open in browser: http://192.168.188.177:8765

Or test with curl:
```bash
curl http://192.168.188.177:8765
# Should return: {"status":"ok","model":"...","device":"..."}
```

## Client Configuration (on clawd)

### Option 1: Environment Variable (recommended)

Add to OpenClaw config:

```json
{
  "skills": {
    "entries": {
      "qwen-tts": {
        "enabled": true,
        "env": {
          "QWEN_TTS_REMOTE": "http://192.168.188.177:8765",
          "QWEN_TTS_SPEAKER": "Vivian",
          "QWEN_TTS_LANGUAGE": "Italian"
        }
      }
    }
  }
}
```

### Option 2: Command Line

```bash
scripts/tts.py "Ciao!" --remote http://192.168.188.177:8765 -o audio.wav
```

### Option 3: Export Variable

```bash
export QWEN_TTS_REMOTE=http://192.168.188.177:8765
scripts/tts.py "Ciao!" -o audio.wav
```

## Testing

On clawd machine:

```bash
cd /path/to/qwen-tts
scripts/tts.py "Test remoto dal Mac" --remote http://192.168.188.177:8765 -l Italian -o /tmp/test.wav
```

Should output: `/tmp/test.wav`

## API Reference

### POST /tts

Generate speech from text.

**Request:**
```json
{
  "text": "Text to synthesize",
  "language": "Italian",
  "speaker": "Vivian",
  "instruct": "Optional instruction",
  "model": "Qwen/Qwen3-TTS-12Hz-0.6B-CustomVoice"
}
```

**Response:** WAV audio file (audio/wav)

### GET /speakers

List available speakers.

**Response:**
```json
{
  "speakers": {
    "Vivian": {
      "lang": "Chinese",
      "desc": "Bright, slightly edgy young female"
    },
    ...
  }
}
```

### GET /

Health check.

**Response:**
```json
{
  "status": "ok",
  "model": "Qwen/Qwen3-TTS-12Hz-0.6B-CustomVoice",
  "device": "mps"
}
```

## Performance

**Mac with M-series (MPS):**
- Model load: ~5-10 seconds (first time only)
- Synthesis: ~1-3 seconds per phrase
- Memory: ~2-4GB (depends on model)

**Recommended:**
- Use 0.6B model for faster responses
- Use 1.7B model for better quality (if RAM permits)
- Keep server running (fast responses after first load)

## Autostart (Optional)

### Using launchd (Mac)

Create `~/Library/LaunchAgents/com.qwen.tts.plist`:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>Label</key>
    <string>com.qwen.tts</string>
    <key>ProgramArguments</key>
    <array>
        <string>/Users/YOUR_USER/qwen-tts-server/bin/python3</string>
        <string>/Users/YOUR_USER/qwen-tts-server/server.py</string>
        <string>--host</string>
        <string>0.0.0.0</string>
        <string>--port</string>
        <string>8765</string>
        <string>--preload</string>
    </array>
    <key>RunAtLoad</key>
    <true/>
    <key>KeepAlive</key>
    <true/>
    <key>StandardOutPath</key>
    <string>/tmp/qwen-tts.log</string>
    <key>StandardErrorPath</key>
    <string>/tmp/qwen-tts.error.log</string>
</dict>
</plist>
```

Load:
```bash
launchctl load ~/Library/LaunchAgents/com.qwen.tts.plist
```

## Troubleshooting

**Server not accessible:**
- Check Mac firewall settings
- Verify server is listening: `lsof -i :8765`
- Test locally on Mac first: `curl http://localhost:8765`

**Model download slow:**
- First run downloads ~600MB (0.6B) or ~1.7GB (1.7B)
- Wait for completion, then restart server

**Out of memory:**
- Use 0.6B model instead of 1.7B
- Close other applications
- Check Activity Monitor for memory usage
