---
name: weather-query
description: "天气查询：使用和风天气（JWT+Host）获取实时天气与未来预报；支持城市名/LocationID/经纬度；缺省地点可用 QWEATHER_DEFAULT_LOCATION。"
tools:
  - qweather_location_lookup
  - weather_now
  - weather_forecast
functions:
  - qweather_location_lookup
  - weather_now
  - weather_forecast
---

# 目标

- 给用户提供可靠的实时天气与预报（不依赖通用 web_search）。
- 自动处理地点输入（城市名/经纬度/locationId）。
- 支持“今天/明天/后天/未来N天”等表达。

# 触发条件

- 用户提到：天气、气温、下雨、降温、风、湿度、预报、今天/明天/后天、未来几天。
- 一旦判定是天气问题，优先本 skill。

# 工作流

1) 获取地点
- 若用户提供地点：调用 qweather_location_lookup({location})
- 若未提供地点：
  - 若 env 存在 QWEATHER_DEFAULT_LOCATION：使用默认地点，并明确说明“按默认地点查询”
  - 否则追问用户城市/地点

2) 判断查询类型
- “现在/当前/实时”：调用 weather_now({location})
- “今天/明天/后天/未来N天”：调用 weather_forecast({location, days})

建议 days 映射：
- 今天：days=1
- 明天：days=2（输出前2天，重点标明第2天）
- 后天：days=3（重点标明第3天）
- “未来几天”：默认 days=3；用户说 N 天则用 N（上限 15）

3) 输出格式
- 地点（解析后的 name）
- 实时：天气现象、气温/体感、湿度、风向风力、观测时间
- 预报：每天最高/最低、白天/夜间天气、降水（如有）、风力

# 约束

- 不要使用 web_search 代替天气数据源。
- API 失败时：返回明确错误，并提示检查 env：
  - QWEATHER_API_HOST / QWEATHER_PROJECT_ID / QWEATHER_CREDENTIALS_ID / QWEATHER_PRIVATE_KEY_PATH
  - 或使用 QWEATHER_DEFAULT_LOCATION 设置默认查询地点
