# Quizlet Set Design

## Build Sequence

1. Define target outcome for the set (exam, interview, language practice, or weekly review).
2. Split source material into atomic facts, processes, and decision points.
3. Convert each unit into one prompt and one unambiguous answer.
4. Apply tags by topic, difficulty, and source.
5. Run a final ambiguity pass before first study session.

## Prompt Patterns That Work

- Definition prompt: clear term with domain context.
- Process prompt: one step or one cause-effect relation per card.
- Contrast prompt: distinguish two commonly confused concepts.
- Scenario prompt: short situation followed by one decision.

## Quality Checks Before Publishing

- One correct answer is obvious to an expert and not guessable by wording tricks.
- Prompt text is short enough to read once without re-parsing.
- Answer does not include extra trivia unrelated to the prompt.
- Similar cards have explicit context cues to avoid interference.

## Rewrite Heuristics

- If a card is failed twice in one week, simplify wording and add domain cue.
- If two cards test overlapping facts, merge or separate by context.
- If a card answer exceeds one short sentence, split into two cards.
- If a card requires memorizing a list, convert list items into separate prompts.

## Set Size Guidance

- 15-30 cards for quick weekly refreshers.
- 30-60 cards for one exam module.
- 60+ only when split into focused sub-sets with clear tags.

## Naming Convention

Use names that encode scope and timeline:
- `Biology Cell Signaling Midterm Week 3`
- `Spanish Irregular Verbs A2 Sprint`
- `Product Metrics Interview Core Set`

Avoid names like `Chapter 4` without subject or goal context.
