# Quiz Types

## Knowledge Quizzes

**Purpose:** Assess learning, certify competency, reinforce material.

**Best practices:**
- Align questions to learning objectives (if no objective, question doesn't belong)
- Mix difficulty levels (easy → medium → hard builds confidence)
- Provide immediate feedback with explanations
- Allow review of incorrect answers after completion
- Consider retakes with question shuffling

**Question formats:**
- Multiple choice (4-5 options ideal)
- True/False (use sparingly — 50% guess rate)
- Fill in the blank (tests recall, not recognition)
- Matching (good for relationships and categories)
- Ordering/sequencing (for processes)

**Scoring:** Percentage or points. Consider partial credit for multi-part questions.

---

## Personality Quizzes

**Purpose:** Entertainment, engagement, self-discovery, shareability.

**Best practices:**
- 5-12 questions max (attention span)
- Questions should feel revealing but fun
- Every answer maps to one or more outcome traits
- Results must feel personalized and positive
- Include shareable image with result

**Question formats:**
- "Which would you rather..." scenarios
- Image selection ("Pick the room you'd live in")
- Sliding scales ("Introvert ← → Extrovert")
- Forced ranking

**Scoring:** Each answer adds points to outcome categories. Highest score determines result.

**Outcomes:** 4-8 result types. Each needs:
- Catchy name ("The Strategist", "The Creative")
- Detailed description (why this fits them)
- What it means for them
- Call to action or recommendation

---

## Assessment Quizzes

**Purpose:** Diagnose skill level, identify gaps, recommend next steps.

**Best practices:**
- Test across multiple competency areas
- Adaptive difficulty if possible (harder questions after correct answers)
- Results show strengths AND growth areas
- Actionable: "Based on your results, we recommend..."
- Often used for course placement, hiring, or training needs analysis

**Question formats:**
- Scenario-based ("What would you do if...")
- Case studies with multiple questions
- Practical application problems
- Self-assessment scales (with behavioral anchors)

**Scoring:** Multi-dimensional rubric. Score each competency area separately.

**Results:** Spider/radar chart showing competency levels. Narrative explanation. Recommended actions.

---

## Lead Generation Quizzes

**Purpose:** Capture email addresses by gating valuable results.

**Best practices:**
- Value of results must exceed friction of email entry
- 5-8 questions max (fast completion)
- Show progress: "Almost there!"
- Gate AFTER completion, BEFORE results
- Results page = landing page (CTA, offer, next step)

**Effective topics:**
- "What type of X are you?" (curiosity)
- "How ready are you for Y?" (self-assessment)
- "Which Z is right for you?" (product recommendation)
- "Test your knowledge of..." (ego challenge)

**Email capture best practices:**
- Explain what they'll get (detailed results, PDF, etc.)
- Minimal fields (email only, or email + first name)
- Privacy reassurance
- Mobile-optimized form

---

## Trivia Quizzes

**Purpose:** Entertainment, community engagement, brand awareness.

**Best practices:**
- Mix easy and hard (everyone should get some right)
- Interesting facts in answer explanations
- Timer adds excitement (optional)
- Leaderboards drive competition
- Regular new quizzes keep users returning

**Formats:**
- Daily/weekly quizzes
- Themed rounds
- Multiplayer real-time
- Progressive difficulty

**Gamification:**
- Points and streaks
- Badges and achievements
- Social sharing ("I scored 8/10 on...")
- Head-to-head challenges
