# Writing Effective Quiz Questions

## Question Structure

**Stem:** The question or incomplete statement.
- Clear and concise
- Contains all necessary context
- One interpretation only
- Avoid negatives ("Which is NOT...")

**Correct answer:** Obviously correct to someone who knows the material.

**Distractors:** Wrong answers that seem plausible to someone who doesn't know.

---

## Good Distractors

Distractors should be:
- Grammatically consistent with stem
- Similar length to correct answer
- Plausible (common misconceptions, related concepts)
- Not obviously wrong

**Bad distractors:**
- Joke answers
- "All of the above" / "None of the above"
- Answers that don't grammatically fit the stem
- One obviously wrong with three plausible options

**Good distractor sources:**
- Common mistakes students make
- Related but incorrect concepts
- Partial truths
- Things that sound right but aren't

---

## Question Types

### Multiple Choice
Best for: Knowledge verification, recognition.

```
What is the capital of Australia?
A) Sydney ← Common misconception
B) Melbourne ← Second-largest city
C) Canberra ← Correct
D) Brisbane ← Another major city
```

### True/False
Best for: Binary facts, quick checks.
- Avoid double negatives
- Statement should be clearly true OR false
- Don't use "always" or "never" (usually make answer obvious)

### Fill in the Blank
Best for: Recall, terminology.
- Blank should be a key concept, not trivial word
- Only one correct answer (or explicit list of acceptable alternatives)
- Provide context around the blank

### Matching
Best for: Relationships, categories, definitions.
- More options than stems (prevents elimination guessing)
- Clear relationship being tested
- All items in same category

### Ordering/Sequencing
Best for: Processes, timelines, procedures.
- Steps should be distinct (not interchangeable)
- 4-7 items (more becomes tedious)

---

## Difficulty Calibration

**Easy:** Tests recognition of key concepts.
- Direct recall from material
- Obvious distractors
- Single-step thinking

**Medium:** Tests understanding and application.
- Requires connecting concepts
- Plausible distractors from related topics
- May require 2-step reasoning

**Hard:** Tests analysis, synthesis, edge cases.
- Subtle distinctions
- All options seem plausible
- Requires deep understanding or experience

**Calibration process:**
1. Write questions targeting each difficulty level
2. Test with 5-10 people
3. If >90% get it right → Too easy
4. If <30% get it right → Too hard or unclear
5. Adjust based on actual performance data

---

## Common Mistakes

**Double-barreled questions:**
❌ "Do you understand variables and loops?"
✅ Split into two questions

**Testing trivia vs objectives:**
❌ "In what year was Python created?"
✅ "What does the `len()` function return?"

**Clues in the question:**
❌ "What is the largest mammal in the ocean?"
(ocean = hint toward whale)
✅ "What is the largest mammal on Earth?"

**Correct answer longer than distractors:**
People tend to pick the most detailed answer. Make all options similar length.

**Pattern in answer positions:**
Randomize correct answer positions across quiz.

---

## Review Checklist

Before publishing questions:
- [ ] Stem is clear and unambiguous
- [ ] Only one defensibly correct answer
- [ ] Distractors are plausible
- [ ] No grammatical clues
- [ ] Appropriate difficulty for audience
- [ ] Tests actual learning objective
- [ ] Explanation ready for incorrect answers
