---
name: quiz-battle
description: Интерактивная викторина по школьным предметам и программированию с inline кнопками. Используй когда пользователь просит поиграть в викторину, проверить знания по математике, английскому, программированию или другим школьным предметам.
user-invocable: true
---

# Quiz Battle — Школьная Викторина

Интерактивная викторина по школьным предметам и программированию.

## Как использовать

### 1. Запуск викторины

Когда пользователь просит поиграть — предложи выбрать тему:

```
🎮 Quiz Battle!

Выбери предмет:

[📐 Математика] [🌍 Английский]
[💻 Программирование] [🔬 Наука]
[📚 История] [🎲 Всё подряд]
```

### 2. Структура вопроса

Используй `message` tool с параметром `buttons`:

```json
{
  "action": "send",
  "channel": "telegram",
  "target": "<user_id>",
  "message": "🏆 Вопрос 1/5\n\nЧему равно 15 × 8?",
  "buttons": [
    [{"text": "120", "callback_data": "quiz:q1:a"}],
    [{"text": "115", "callback_data": "quiz:q1:b"}],
    [{"text": "125", "callback_data": "quiz:q1:c"}],
    [{"text": "130", "callback_data": "quiz:q1:d"}]
  ]
}
```

### 3. Обработка ответа

Когда пользователь выбирает ответ:
- ✅ Правильно: "Верно! +10 очков 🎯"
- ❌ Неправильно: "Неверно! Правильный ответ: 120"

### 4. Темы для викторин

**📐 Математика:**
- Умножение и деление
- Дроби и проценты
- Уравнения
- Геометрия

**🌍 Английский язык:**
- Перевод слов
- Грамматика (tenses, articles)
- Идиомы
- Ложные друзья переводчика

**💻 Программирование:**
- Python basics (переменные, циклы, списки)
- JavaScript basics
- HTML/CSS
- Алгоритмы

**🔬 Наука:**
- Физика (законы, формулы)
- Химия (элементы, реакции)
- Биология (клетки, организмы)

**📚 История:**
- Даты и события
- Исторические личности
- Великие открытия

## Примеры вопросов по темам

**Математика:**
```
🏆 Вопрос: Чему равно 25% от 80?
[15] [20] [25] [30]
Ответ: 20
```

**Английский:**
```
🏆 Вопрос: Переведи "butterflies in stomach":
[Голод] [Волнение] [Боль] [Радость]
Ответ: Волнение
```

**Программирование:**
```
🏆 Вопрос: Что выведет print(2 ** 3) в Python?
[5] [6] [8] [9]
Ответ: 8
```

### 5. Финал

В конце покажи результат:
```
🏆 Викторина завершена!
━━━━━━━━━━━━━━━━
🎯 Твой счёт: 40/50
📊 Правильных: 4/5
🔥 Отличный результат!

[🔄 Играть снова]
```

## Стиль общения

- Дружелюбный и бодрый
- Используй эмодзи: 🎯 ✅ ❌ 🏆 🔥 ⚡
- Поддерживай игрока: "Молодец!", "Так держать!"
- При ошибке — мягко: "Не совсем, но ты близко!"

## Пример полного цикла

```
User: поиграем в викторину!

Bot: 🎮 Quiz Battle!
Выбери предмет:

[📐 Математика] [🌍 Английский]
[💻 Программирование] [🎲 Всё подряд]

---

User: [📐 Математика]

Bot: 🏆 Вопрос 1/5 (Математика)

Чему равно 144 ÷ 12?

[10] [11] [12] [13]

---

User: [12]

Bot: ✅ Верно! +10 очков 🎯
[➡️ Следующий вопрос]
```
