---
name: quit-vaping
description: Quit vaping with nicotine-free streak tracking, craving tools, and health milestones
author: clawd-team
version: 1.0.0
triggers:
  - "quit vaping"
  - "vape free"
  - "nicotine craving"
  - "vaping streak"
  - "stop vaping"
---

# Quit Vaping

Break nicotine addiction with persistent streak tracking, craving management, and science-backed health recovery milestones.

## What it does

- **Sobriety Tracking**: Records your quit date and calculates your nicotine-free streak in real-time
- **Craving Management**: Provides immediate tools and techniques when cravings hit—breathing exercises, delay tactics, urge logging
- **Health Timeline**: Shows what's happening in your body at 20 minutes, 24 hours, 48 hours, 1 week, 1 month, and 3 months smoke-free
- **Progress Dashboard**: Visualizes days quit, money saved, and health wins compared to ongoing vaping costs

## Usage

**Log Quit Date**
- Set your official quit date when you're ready to start
- Skill automatically begins tracking from that moment
- Recalculate anytime if you need to restart

**Handle Cravings**
- Request an immediate craving response when nicotine hits
- Get quick breathing techniques, delay tactics (5-10 minute activities), or just-in-time motivation
- Log the craving moment to track patterns and triggers

**Check Progress**
- View your current streak (days/hours since quit)
- See how far you've come compared to yesterday, last week, first month
- Get celebration messages at milestone hits (7 days, 30 days, 100 days)

**Health Recovery**
- Follow your body's actual recovery timeline
- See improvements: oxygen levels normalizing, heart rate steadying, taste/smell returning
- Connect physical wins to motivation for the next phase

**Money Saved**
- Track dollars not spent on vaping based on your typical usage
- See cumulative savings—visual proof of financial freedom
- Compare daily/weekly/monthly savings to other goals

## Health Timeline

| Milestone | What's Happening |
|-----------|------------------|
| **20 minutes** | Blood pressure and heart rate drop back to normal levels |
| **24 hours** | Carbon monoxide clears from your system; lung function begins to improve |
| **48 hours** | Nerve endings regrow; taste and smell start returning |
| **1 week** | Breathing becomes easier; nicotine withdrawal peaks then subsides; sleep normalizes |
| **1 month** | Lung function improves 30%; circulation strengthens; energy levels rise |
| **3 months** | Lung capacity increases up to 10%; coughing decreases; skin clarity improves |

## Tips

- **Stack small wins**: Celebrate each craving you didn't give in to. Track them. They're proof you're stronger than nicotine.
- **Know your triggers**: Log where, when, and what you were doing when cravings hit. Patterns emerge. Break them intentionally.
- **Replace the ritual**: Vaping often fills a slot in your day (breaks, stress, boredom). Find a replacement—gum, walks, cold water, fidget.
- **Build accountability**: Share your streak with someone who supports your quit. Peer pressure works in reverse—it keeps you going.
- **All data stays local on your machine**: Your quit journey, streaks, and health milestones are stored only on your device. No tracking, no servers, no surveillance—just you and your freedom.
