---
name: quit-smoking
description: Quit cigarettes with smoke-free tracking, craving support, and health recovery timeline
author: clawd-team
version: 1.0.0
triggers:
  - "quit smoking"
  - "smoke free"
  - "cigarette craving"
  - "smoking streak"
  - "stop cigarettes"
---

# Quit Smoking

Become smoke-free with persistent tracking, craving support, and a health recovery roadmap.

## What it does

- **Quit tracking**: Start a quit date, track consecutive days smoke-free with persistent memory
- **Craving support**: Get real-time support when cravings hit—substitutions, breathing exercises, motivation
- **Health benefits timeline**: See the medical benefits of quitting unfold (heart rate drops in 20 min, senses improve in 48 hrs, lung function improves in months)
- **Progress milestones**: Celebrate 1 day, 1 week, 1 month, 3 months, 6 months, 1 year smoke-free
- **Money saved tracker**: Watch dollars add up as you quit—based on typical pack cost

## Usage

**Start your quit**
- "I'm quitting smoking today"
- "Set my quit date to [date]"
- "Help me quit cigarettes"

**Handle cravings**
- "I have a craving"
- "Help me through this craving"
- "What can I do instead of smoking?"
- "Give me a breathing exercise"

**Track progress**
- "How many days smoke-free?"
- "Show my smoking streak"
- "What's my quit milestone?"
- "How much money have I saved?"

**Health gains**
- "What health benefits do I get from quitting?"
- "When will my lungs heal?"
- "How long until cravings stop?"

**Money saved**
- "How much have I saved so far?"
- "What could I buy with my saved money?"
- "Calculate my quit savings"

## Health Timeline

| Milestone | Health Benefit |
|-----------|---|
| **20 minutes** | Heart rate and blood pressure drop |
| **8 hours** | Oxygen levels normalize, nicotine clears from bloodstream |
| **24 hours** | Risk of heart attack decreases |
| **48 hours** | Taste and smell improve, nerve endings repair |
| **2 weeks** | Circulation and lung function improve |
| **1 month** | Skin quality improves, coughing subsides |
| **1 year** | Risk of heart disease cut in half, lung function up 30% |

## Tips

- **Track your wins**: Every day smoke-free is a victory. The streak is your motivation.
- **Replace the ritual**: Smoking is a habit. Substitute gum, water, a walk, or deep breathing when cravings hit.
- **Tell someone**: Accountability works. Let friends or family know you're quitting—they'll support you.
- **Ride out cravings**: Most cravings last 3-5 minutes. Use a timer, breathe, wait it out.
- **All data stays local on your machine**: Your quit journey, cravings, and health milestones are stored only on your device—no cloud sync, no tracking, completely private.
