---
name: quit-alcohol
description: Track sobriety with alcohol-free streaks, craving management, and recovery milestones
author: clawd-team
version: 1.0.0
triggers:
  - "quit drinking"
  - "sober streak"
  - "alcohol free"
  - "urge to drink"
  - "sobriety check"
---

# Quit Alcohol

Your personal sobriety companion. Track streaks, manage urges, celebrate wins.

## What it does

- **Sobriety tracking**: Records your alcohol-free streak in days, weeks, and months
- **Urge management**: Logs cravings, identifies triggers, suggests coping strategies
- **Milestone celebrations**: Marks 24 hours, 1 week, 30 days, 90 days, and 1-year achievements
- **Progress dashboard**: Visual summaries of your recovery journey
- **Support reminders**: Links to local resources and recovery communities

## Usage

### Start sobriety
- "Start my sobriety journey today" - Begin tracking from now
- "My quit date is [date]" - Set a historical start date
- "Reset my sobriety tracker" - Start fresh if relapsed

### Handle cravings
- "I'm having an urge" - Log a craving and get immediate coping suggestions
- "What triggered this?" - Analyze patterns in your urges
- "Distraction ideas" - Get activities to redirect the urge

### Check progress
- "How long have I been sober?" - View your current streak
- "Show my stats" - See days/weeks/months and patterns
- "Next milestone?" - What achievement is coming up

### Money saved
- "How much have I saved?" - Calculate money not spent on alcohol (based on your typical spend)
- "Savings goal" - Set a target and track progress toward it

### Get support
- "Find meetings near me" - Locate AA/SMART Recovery/other groups
- "Support resources" - Get phone numbers and crisis lines
- "Tell me why I quit" - Reaffirm your reasons for sobriety

## Milestones

| Duration | Achievement |
|----------|-------------|
| 24 hours | First steps |
| 1 week | Breaking the pattern |
| 30 days | One month strong |
| 90 days | Three months—transformation begins |
| 1 year | One year sober—you're a fighter |

## Tips

- **Be honest about triggers**: Log what sets off cravings (stress, certain places, people, emotions). Patterns reveal themselves.
- **Plan your escape**: Before urges hit, pre-decide your response—call a friend, go for a walk, hit the gym.
- **Celebrate small wins**: Each day sober is a win. Acknowledge it. Momentum compounds.
- **Connect with others**: Share your journey with people who understand. Vulnerability builds resilience.
- **All data stays local on your machine**: Your recovery is private. No cloud storage, no corporate tracking—complete confidentiality.

---

*Note: For medical withdrawal concerns or if you're experiencing severe withdrawal symptoms, consult a healthcare provider. Alcohol withdrawal can be dangerous and may require professional medical support.*
