---
name: quick-reminders
description: "Zero-LLM one-shot reminders (<48h) via nohup sleep + openclaw message send, operated via {baseDir}/scripts/nohup-reminder.sh."
metadata: {"openclaw":{"emoji":"⏰","requires":{"bins":["jq","openclaw"]}}}
user-invocable: true
---

# Quick Reminders

One-shot reminders for **< 2 days ahead**. Agent composes the final delivery text at creation time. At fire time a background process sends it via `openclaw message send` — zero LLM tokens.

## Guardrail — 2+ days? Use calendar instead

If the user asks for a reminder **2 or more days from now**, do NOT use this skill.
Instead, create a calendar event (if the user has a calendar or an appropriate skill is available) with an appropriate reminder notification.
Explain briefly: "I'll add it to your calendar with a reminder so it won't be lost."

---

All operations go through the CLI:
`bash {baseDir}/scripts/nohup-reminder.sh <command> [args]`

> If `{baseDir}` is not resolved, use workspace-relative: `bash ./skills/quick-reminders/scripts/nohup-reminder.sh <command> [args]`

`--target`: Delivery target from TOOLS.md (§ Reminders). Required for `add`.
Format depends on channel (e.g. Telegram chat ID, WhatsApp E.164 number, Discord channel ID).
If missing in TOOLS.md — check `session_status` tool for `deliveryContext.to` (strip channel prefix like `telegram:`), save to TOOLS.md, and use it.

**Channel:** Telegram by default. Override with `--channel <name>` (e.g. `whatsapp`, `discord`, `signal`, `imessage`).

---

## Commands

### Add
```
nohup-reminder.sh add "Reminder text here" --target <chat_id> -t TIME [--channel CH] [-z TIMEZONE]
```
- Text: the **exact message** the user will receive. Compose it yourself — keep your voice, add a CTA or helpful note when relevant.
- `-t`: relative (`30s`, `20m`, `2h`, `1d`, `1h30m`) or absolute ISO-8601 (`2026-02-07T16:00:00+03:00`)
- `-z`: IANA timezone for naive absolute times (default: system local)

### List
```
nohup-reminder.sh list
```
Auto-prunes fired entries.

### Remove
```
nohup-reminder.sh remove ID [ID ...]
nohup-reminder.sh remove --all
```

---

## Composing the reminder message

The reminder should feel like a **friend texting you**, not a system notification. No robotic phrasing.

**Never:**
- "Reminder: call John"
- "This is your reminder to..."
- "You asked to be reminded about..."
- "Task: load dishwasher"

**Instead — sound human:**
- "Hey, you wanted to call John"
- "Time to call John back"
- "So... dishwasher time"
- "I know you hate it, but the dishwasher won't load itself"
- "Package is waiting — go grab it"

**Guidelines:**
- Use casual openers: "Hey", "So...", "Heads up", "{UserName}", or just dive in
- Okay to add light humor or empathy when it fits ("I know, I know...")
- Keep it short — one line, no formalities
- The user reads this out of context hours later; it should still make sense

---

## Examples (copy-paste ready, replace `<chat_id>` with actual ID)

User: "Remind me to call John in 2 hours"
```bash
bash {baseDir}/scripts/nohup-reminder.sh add "Hey, you wanted to call John" --target <chat_id> -t 2h
```

User: "Remind me in 20 minutes to grab the laundry"
```bash
bash {baseDir}/scripts/nohup-reminder.sh add "Laundry's ready — go grab it" --target <chat_id> -t 20m
```

User: "Set a reminder for today at 6pm — pick up the package"
```bash
bash {baseDir}/scripts/nohup-reminder.sh add "Package is waiting for you" --target <target> -t "2026-02-07T18:00:00" -z "America/New_York"
```

User: "Remind me via WhatsApp in 30 min to check the oven"
```bash
bash {baseDir}/scripts/nohup-reminder.sh add "Check the oven!" --target +15551234567 -t 30m --channel whatsapp
```

User: "What reminders do I have?"
```bash
bash {baseDir}/scripts/nohup-reminder.sh list
```

User: "Cancel reminder #3"
```bash
bash {baseDir}/scripts/nohup-reminder.sh remove 3
```

User: "Cancel reminders 1 and 4"
```bash
bash {baseDir}/scripts/nohup-reminder.sh remove 1 4
```

User: "Clear all my reminders"
```bash
bash {baseDir}/scripts/nohup-reminder.sh remove --all
```

---

## Rules

1. **Compose the delivery text yourself at creation time.** No LLM runs when it fires.
2. Text must make sense to the user out of context.
3. Confirm with **one short word/phrase** — e.g. "Will do", "Will remind you", "Got it", in future tense. Not "Done", "Added", "Created", "Reminder X is set for Y". No IDs, no times, no details.
4. To change: remove old, then add new.
