# Question Techniques

## The Socratic Method

Ask questions that guide discovery rather than giving answers.

**Core moves:**
1. **Clarify** — "What do you mean by X?"
2. **Probe assumptions** — "What are you taking for granted?"
3. **Request evidence** — "How do you know that?"
4. **Explore implications** — "If that's true, what follows?"
5. **Challenge viewpoint** — "Could there be another way to see this?"
6. **Question the question** — "Why is this question important?"

**When to use:** Teaching, coaching, therapy, philosophical inquiry, helping someone think through a problem.

---

## SPIN Questioning

Framework for sales/discovery conversations.

| Type | Purpose | Example |
|------|---------|---------|
| **S**ituation | Understand current state | "How does your team currently handle X?" |
| **P**roblem | Surface difficulties | "What challenges come up with that?" |
| **I**mplication | Deepen the pain | "What happens to your results when that occurs?" |
| **N**eed-payoff | Envision solution value | "If you could fix that, what would change?" |

**Sequencing:** Don't jump to Implication before establishing Problem. Build the case.

---

## The Funnel

Start broad, narrow progressively.

```
Wide: "Tell me about your morning routine"
      ↓
Narrower: "You mentioned coffee — walk me through that"
          ↓
Specific: "What made you switch to cold brew?"
```

**When to use:** Interviews, discovery, when you don't know what's important yet.

---

## The 5 Whys

Ask "why" repeatedly to find root cause.

1. "Why did the deployment fail?" → Missing config
2. "Why was config missing?" → Not in checklist
3. "Why not in checklist?" → New service, checklist outdated
4. "Why outdated?" → No owner for checklist maintenance
5. "Why no owner?" → Nobody assigned during reorg

**Root cause:** Process gap during reorg, not technical issue.

**When to use:** Problem analysis, incident reviews, understanding motivation.

---

## The Ladder of Abstraction

Move up (abstract) or down (concrete) based on need.

**Moving down (concrete):**
- "Can you give me an example?"
- "What did that actually look like?"
- "Walk me through a specific instance"

**Moving up (abstract):**
- "What's the pattern here?"
- "If you stepped back, what's this really about?"
- "What's the underlying principle?"

---

## Open vs Closed Questions

| Type | Use When | Examples |
|------|----------|----------|
| **Open** | Exploring, discovering | "How do you feel about X?" / "What happened?" |
| **Closed** | Confirming, clarifying | "Was that before or after the meeting?" |

**Default to open** in discovery contexts. Use closed to nail down specifics.

---

## The Echo

Repeat their words back as a question.

Person: "It's been really frustrating."
You: "Frustrating?"

**Why it works:** Non-directive, invites elaboration, shows listening.

---

## The Pause

Strategic silence after a question.

- Count to 5 in your head before filling silence
- Resist the urge to rephrase or offer multiple choice
- Let discomfort work in your favor

**When to use:** After important questions, when someone seems to be thinking, when you suspect more is coming.

---

## Scaling Questions

Used in coaching/therapy to make abstract concrete.

- "On a scale of 1-10, how confident are you?"
- "What would make it a 6 instead of a 4?"
- "What was different when it was a 9?"

---

## The Hypothetical

Create safe distance to explore sensitive topics.

- "If you could change one thing without consequence, what would it be?"
- "Imagine it's a year from now and this is solved — what happened?"
- "If a colleague came to you with this problem, what would you tell them?"

---

## Pre-Mortem

Project failure into the future to surface concerns.

- "Imagine this project failed completely. What went wrong?"
- "If we're looking back in a year and this didn't work, what was the cause?"

**When to use:** Planning, risk assessment, surfacing unspoken concerns.
