# Question Contexts

## research

**User Research / Interviews**

**Goal:** Extract genuine behaviors, needs, and pain points without biasing responses.

**Core principles:**
- Ask about past behaviors, not hypotheticals ("Tell me about the last time..." vs "Would you ever...")
- Follow the emotion — when they show frustration/excitement, probe there
- Let them finish before following up

**Key capabilities:**
- Real-time leading question detection — suggest neutral alternatives
- Adaptive follow-up generation based on responses
- Live insight tagging (pain points, workarounds, unmet needs)
- Cross-interview pattern recognition after multiple sessions
- Silence calibration — know when to wait vs. prompt

**Example sequence:**
1. "Walk me through how you currently handle X..."
2. [Listen for friction points]
3. "You mentioned Y was frustrating — tell me more about that"
4. "What have you tried to solve that?"
5. "What would it look like if that problem didn't exist?"

---

## sales

**Sales Discovery Calls**

**Goal:** Qualify prospects, uncover pain, understand decision process.

**Core principles:**
- SPIN framework: Situation → Problem → Implication → Need-payoff
- Don't pitch until you've found real pain
- Track qualification criteria as you go

**Key capabilities:**
- Question sequencing based on SPIN framework
- Pain signal detection (frustration language, cost mentions, urgency)
- Qualification scoring (BANT/MEDDIC gaps flagged)
- Objection pattern recognition with follow-up suggestions
- Decision process mapping (stakeholders, timeline, budget)
- Implication question generation to deepen pain

**SPIN examples:**
- Situation: "How does your team currently handle X?"
- Problem: "What challenges come up with that approach?"
- Implication: "What happens to your pipeline when that occurs?"
- Need-payoff: "If you could eliminate that, what would change?"

---

## coaching

**Coaching / 1:1 Meetings**

**Goal:** Help the person find their own answers, build growth mindset.

**Core principles:**
- Socratic method — questions over answers
- Hold the mirror, don't hold the pen
- Separate coaching mode (exploring) from directing mode (solving)

**Key capabilities:**
- Context recall across sessions (remember prior conversations)
- Socratic follow-up suggestions ("What's behind that?")
- Deflection detection when getting surface answers
- Coaching stance awareness (directive vs non-directive)
- Feedback framing as reflective questions
- Career conversation scaffolding

**Powerful coaching questions:**
- "What would success look like here?"
- "What's holding you back?"
- "If you had to decide today, which way would you lean?"
- "What would you tell someone else in this situation?"
- "What's the cost of not addressing this?"

---

## journalism

**Journalism / Investigation**

**Goal:** Get to the truth, surface contradictions, handle evasion.

**Core principles:**
- Never accept the first answer as complete
- Cross-reference everything
- Strategic sequencing — save hardest questions for when rapport is built

**Key capabilities:**
- Contradiction detection across sources and prior statements
- Evasion pattern recognition (pivots, qualifiers, adjacent answers)
- Power dynamic mapping (who they report to, fear, depend on)
- Strategic question sequencing for maximum effectiveness
- Sensitive topic framing (trauma, legal exposure, reputation)
- Claim verification queueing for fact-checking
- Gap analysis — what's conspicuously missing from the record

**Handling evasion:**
- Direct redirect: "I asked about X, but you answered about Y — can we go back to X?"
- Echo back: "So you're saying..." (force them to own it or correct)
- Silence: Let uncomfortable pauses do the work
- Third-party framing: "Others have said... — how do you respond?"

---

## learning

**Learning / Understanding**

**Goal:** Build genuine comprehension through active questioning.

**Core principles:**
- The quality of your questions determines the depth of your learning
- Assumptions are invisible until questioned
- Complex topics decompose into simpler questions

**Key capabilities:**
- Confusion detection — pinpoint where mental model breaks
- Topic decomposition into smaller askable questions
- Socratic counter-questions to deepen thinking
- Hidden assumption exposure
- Adjacent question suggestion
- Question type distinction (factual vs conceptual vs philosophical)
- Vague-to-precise question refinement

**Learning question types:**
- Clarifying: "What do you mean by X?"
- Probing assumptions: "Why do we assume that's true?"
- Probing evidence: "How do we know this?"
- Implications: "If that's true, what follows?"
- Viewpoint: "How might someone else see this?"
- Meta: "Why is this question important?"
