# Question Anti-Patterns

## Leading Questions

**What it is:** Embedding the desired answer in the question.

**Examples:**
- ❌ "Don't you think the new design is better?"
- ❌ "How frustrated were you when that happened?"
- ❌ "Wouldn't you agree that..."

**Fix:**
- ✅ "How do you feel about the new design?"
- ✅ "How did you feel when that happened?"
- ✅ "What's your perspective on..."

---

## Compound Questions

**What it is:** Asking multiple questions at once.

**Example:**
- ❌ "What did you think of the meeting and how would you improve it and who should have been there?"

**Problems:** Person picks easiest to answer, forgets others, you lose control.

**Fix:** One question at a time. Wait for answer. Then next question.

---

## Closed Questions Too Early

**What it is:** Using yes/no questions when exploring.

**Examples:**
- ❌ "Did you like it?"
- ❌ "Was that a problem?"

**Problems:** Limits depth, lets people off easy, misses nuance.

**Fix:** Open first, close later.
- ✅ "What was your experience with it?"
- ✅ "Tell me about the challenges you faced"

---

## Filling Silence

**What it is:** Rushing to fill pauses with clarifications or new questions.

**Example:**
- ❌ "What do you think about — I mean, like, how did it make you feel, or was it more of a practical concern, or..."

**Problems:** Interrupts thinking, offers escape routes, signals impatience.

**Fix:** Ask. Wait. Count to 5 silently. They'll fill the space.

---

## Answering Your Own Question

**What it is:** Providing the answer along with the question.

**Example:**
- ❌ "Do you use Slack for communication, or maybe email, or perhaps something else like Teams?"

**Problems:** Limits imagination, suggests what you want to hear.

**Fix:** 
- ✅ "How does your team communicate?"

---

## The Why Barrage

**What it is:** Overusing "why" which feels interrogatory.

**Example:**
- ❌ "Why did you do that? But why? And why was that important?"

**Problems:** Feels aggressive, triggers defensiveness.

**Fix:** Vary your approach:
- "What led you to that decision?"
- "Help me understand the thinking behind that"
- "What was happening that made that feel right?"

---

## Hypothetical Future Behavior Questions

**What it is:** Asking what someone would do hypothetically.

**Examples:**
- ❌ "Would you pay for this feature?"
- ❌ "How often would you use this?"

**Problems:** People are terrible at predicting their own behavior. They'll say yes to be nice.

**Fix:** Ask about past behavior instead:
- ✅ "Have you ever paid for something like this?"
- ✅ "Tell me about the last time you needed this"

---

## Feature Fishing

**What it is:** Asking if specific features would be useful.

**Examples:**
- ❌ "Would dark mode be helpful?"
- ❌ "What if it had AI integration?"

**Problems:** Confirmation bias. Most people say yes to nice-sounding things.

**Fix:** Ask about problems, not solutions:
- ✅ "What's frustrating about how this works now?"
- ✅ "What would make your workflow easier?"

---

## Stack Ranking Demands

**What it is:** Forcing artificial prioritization.

**Examples:**
- ❌ "What's your NUMBER ONE priority?"
- ❌ "If you could only have one feature..."

**Problems:** Real decisions rarely work this way. Forces false tradeoffs.

**Fix:** Explore constraints:
- ✅ "What's driving the urgency here?"
- ✅ "Which of these could you live without for 6 months?"

---

## Jargon Assumptions

**What it is:** Using technical terms without checking understanding.

**Examples:**
- ❌ "How's your CSAT trending?" (to someone who might not know CSAT)
- ❌ "What's your deployment cadence?"

**Problems:** Embarrasses people who don't know, gets inaccurate answers from those who pretend.

**Fix:** Use plain language or define terms:
- ✅ "How satisfied would you say your customers are overall?"
- ✅ "How often do you release new versions — daily, weekly, monthly?"
