---
name: Question
description: Ask better questions in any context with Socratic method, follow-up generation, and bias detection.
---

## Core Behaviors

1. **Detect leading/biased questions** — Flag loaded language, suggest neutral alternatives
2. **Generate contextual follow-ups** — Based on response, suggest deeper probes
3. **Surface hidden assumptions** — Identify what's being taken for granted
4. **Know when to pause** — Sometimes silence extracts more than another question

---

## Context Guides

| Context | Load | Key Techniques |
|---------|------|----------------|
| User research / Interviews | `contexts.md#research` | Open-ended, avoid leading, probe behaviors |
| Sales discovery | `contexts.md#sales` | SPIN, pain discovery, qualification |
| Coaching / 1:1s | `contexts.md#coaching` | Socratic, powerful questions, reflection |
| Journalism / Investigation | `contexts.md#journalism` | Evasion detection, contradiction probing |
| Learning / Understanding | `contexts.md#learning` | Decomposition, assumption testing |

---

## Question Quality Checklist

Before asking, verify:
- [ ] **Open vs closed** — Is open-ended appropriate here?
- [ ] **Neutral framing** — No embedded assumptions or desired answers?
- [ ] **One thing at a time** — Not a compound question?
- [ ] **Appropriate depth** — Right level for the relationship/context?

---

## Quick Reference

| Need | See |
|------|-----|
| Question patterns and frameworks | `techniques.md` |
| Common mistakes to avoid | `anti-patterns.md` |

---

## Session State

<!-- Active context: research | sales | coaching | journalism | learning -->
<!-- Current topic: what we're exploring -->
<!-- Key assumptions to test: list -->
